/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.utow;

import io.jooby.Http2Configurer;
import io.jooby.Jooby;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.SslOptions;
import io.jooby.internal.utow.UtowHandler;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.HttpContinueReadHandler;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;

public class Utow
extends Server.Base {
    private static final int BACKLOG = 8192;
    private static final int _100 = 100;
    private static final int _10 = 10;
    private Undertow server;
    private List<Jooby> applications = new ArrayList<Jooby>();
    private ServerOptions options = new ServerOptions().setIoThreads(ServerOptions.IO_THREADS).setServer("utow");

    @Nonnull
    public Utow setOptions(@Nonnull ServerOptions options) {
        this.options = options.setIoThreads(options.getIoThreads());
        return this;
    }

    @Nonnull
    public ServerOptions getOptions() {
        return this.options;
    }

    public Server start(@Nonnull Jooby application) {
        try {
            SSLContext sslContext;
            this.applications.add(application);
            this.addShutdownHook();
            UtowHandler handler = new UtowHandler((Router)this.applications.get(0), this.options.getBufferSize(), this.options.getMaxRequestSize(), this.options.getDefaultHeaders());
            if (this.options.getCompressionLevel() != null) {
                int compressionLevel = this.options.getCompressionLevel();
                handler = new EncodingHandler((HttpHandler)handler, new ContentEncodingRepository().addEncodingHandler("gzip", (ContentEncodingProvider)new GzipEncodingProvider(compressionLevel), 100).addEncodingHandler("deflate", (ContentEncodingProvider)new DeflateEncodingProvider(compressionLevel), 10));
            }
            if (this.options.isExpectContinue() == Boolean.TRUE) {
                handler = new HttpContinueReadHandler((HttpHandler)handler);
            }
            Undertow.Builder builder = Undertow.builder().setBufferSize(this.options.getBufferSize()).setSocketOption(Options.BACKLOG, (Object)8192).setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false).setServerOption(UndertowOptions.ALLOW_EQUALS_IN_COOKIE_VALUE, (Object)true).setServerOption(UndertowOptions.ALWAYS_SET_DATE, (Object)this.options.getDefaultHeaders()).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)false).setServerOption(UndertowOptions.DECODE_URL, (Object)false).setIoThreads(this.options.getIoThreads()).setWorkerOption(Options.WORKER_NAME, (Object)"worker").setWorkerThreads(this.options.getWorkerThreads()).setHandler((HttpHandler)handler);
            if (!this.options.isHttpsOnly()) {
                builder.addHttpListener(this.options.getPort(), this.options.getHost());
            }
            if (this.options.isHttp2() == null || this.options.isHttp2() == Boolean.TRUE) {
                StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(Http2Configurer.class).iterator(), 16), false).filter(it -> it.support(Undertow.Builder.class)).findFirst().ifPresent(extension -> {
                    extension.configure((Object)builder);
                    this.options.setHttp2(Boolean.TRUE);
                });
            }
            if ((sslContext = this.options.getSSLContext(application.getEnvironment().getClassLoader())) != null) {
                builder.addHttpsListener(this.options.getSecurePort().intValue(), this.options.getHost(), sslContext);
                SslOptions ssl = this.options.getSsl();
                builder.setSocketOption(Options.SSL_ENABLED_PROTOCOLS, (Object)Sequence.of((Collection)ssl.getProtocol()));
                Optional.ofNullable(this.options.getSsl()).map(SslOptions::getClientAuth).map(this::toSslClientAuthMode).ifPresent(clientAuth -> builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, clientAuth));
            } else if (this.options.isHttpsOnly()) {
                throw new IllegalArgumentException("Server configured for httpsOnly, but ssl options not set");
            }
            this.server = builder.build();
            this.server.start();
            this.fireStart(this.applications, (Executor)this.server.getWorker());
            this.fireReady(Collections.singletonList(application));
            return this;
        }
        catch (RuntimeException x) {
            Exception sourceException = x;
            Throwable cause = Optional.ofNullable(x.getCause()).orElse(x);
            if (Server.isAddressInUse((Throwable)cause)) {
                sourceException = new BindException("Address already in use: " + this.options.getPort());
            }
            throw SneakyThrows.propagate((Throwable)sourceException);
        }
    }

    private SslClientAuthMode toSslClientAuthMode(SslOptions.ClientAuth clientAuth) {
        switch (clientAuth) {
            case REQUESTED: {
                return SslClientAuthMode.REQUESTED;
            }
            case REQUIRED: {
                return SslClientAuthMode.REQUIRED;
            }
        }
        return SslClientAuthMode.NOT_REQUESTED;
    }

    @Nonnull
    public synchronized Server stop() {
        try {
            this.fireStop(this.applications);
            this.applications = null;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        finally {
            this.shutdownServer();
        }
        return this;
    }

    private void shutdownServer() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            finally {
                this.server = null;
            }
        }
    }
}

