/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.utow;

import io.jooby.Body;
import io.jooby.Context;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.internal.utow.UtowContext;
import io.undertow.io.Receiver;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public class UtowBodyHandler
implements Receiver.FullBytesCallback,
Receiver.PartialBytesCallback,
ExchangeCompletionListener {
    private final int bufferSize;
    private final long maxRequestSize;
    private Router.Match route;
    private UtowContext context;
    private long chunkSize;
    private List chunks;
    private Path file;
    private FileChannel channel;
    private long position;

    public UtowBodyHandler(Router.Match route, UtowContext context, int bufferSize, long maxRequestSize) {
        this.route = route;
        this.context = context;
        this.bufferSize = bufferSize;
        this.maxRequestSize = maxRequestSize;
    }

    public void handle(HttpServerExchange exchange, byte[] bytes) {
        this.context.body = Body.of((Context)this.context, (byte[])bytes);
        this.route.execute((Context)this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener next) {
        try {
            Files.deleteIfExists(this.file);
        }
        catch (IOException iOException) {
        }
        finally {
            next.proceed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServerExchange exchange, byte[] chunk, boolean last) {
        try {
            if (chunk.length > 0) {
                this.chunkSize += (long)chunk.length;
                if (this.chunkSize > this.maxRequestSize) {
                    try {
                        this.route.execute((Context)this.context, Route.REQUEST_ENTITY_TOO_LARGE);
                    }
                    finally {
                        this.closeChannel();
                        this.channel = null;
                    }
                    return;
                }
                if (this.chunkSize <= (long)this.bufferSize) {
                    if (this.chunks == null) {
                        this.chunks = new ArrayList();
                    }
                    this.chunks.add(chunk);
                } else {
                    if (this.file == null) {
                        this.file = this.context.getRouter().getTmpdir().resolve("undertow" + System.nanoTime() + "body");
                        this.channel = FileChannel.open(this.file, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                    }
                    if (this.chunks != null) {
                        List source = this.chunks;
                        this.chunks = null;
                        for (Object s : source) {
                            byte[] bytes = (byte[])s;
                            this.channel.write(ByteBuffer.wrap(bytes), this.position);
                            this.position += (long)bytes.length;
                        }
                        source.clear();
                    }
                    this.channel.write(ByteBuffer.wrap(chunk), this.position);
                    this.position += (long)chunk.length;
                }
            }
            if (last) {
                if (this.channel != null) {
                    exchange.addExchangeCompleteListener((ExchangeCompletionListener)this);
                    this.forceAndClose();
                    this.channel = null;
                    this.context.body = Body.of((Context)this.context, (Path)this.file);
                } else {
                    this.context.body = Body.of((Context)this.context, (byte[])this.bytes((int)this.chunkSize));
                }
                this.route.execute((Context)this.context);
            }
        }
        catch (IOException x) {
            try {
                this.context.sendError(x);
            }
            finally {
                this.closeChannel();
                this.channel = null;
                exchange.endExchange();
            }
        }
    }

    private void closeChannel() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void forceAndClose() throws IOException {
        if (this.channel != null) {
            try {
                this.channel.force(true);
            }
            finally {
                this.closeChannel();
            }
        }
    }

    private byte[] bytes(int size) {
        byte[] bytes = new byte[size];
        int offset = 0;
        for (Object c : this.chunks) {
            byte[] chunk = (byte[])c;
            System.arraycopy(chunk, 0, bytes, offset, chunk.length);
            offset += chunk.length;
        }
        return bytes;
    }
}

