/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.utow;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.xnio.IoUtils;

public class UtowChunkedStream
implements IoCallback,
Runnable {
    private ReadableByteChannel source;
    private HttpServerExchange exchange;
    private Sender sender;
    private PooledByteBuffer pooled;
    private IoCallback callback;
    private final long len;
    private long total;

    public UtowChunkedStream(long len) {
        this.len = len;
    }

    public void send(ReadableByteChannel source, HttpServerExchange exchange, IoCallback callback) {
        this.source = source;
        this.exchange = exchange;
        this.callback = callback;
        this.sender = exchange.getResponseSender();
        ServerConnection connection = exchange.getConnection();
        this.pooled = connection.getByteBufferPool().allocate();
        this.onComplete(exchange, this.sender);
    }

    @Override
    public void run() {
        ByteBuffer buffer = this.pooled.getBuffer();
        try {
            buffer.clear();
            int count = this.source.read(buffer);
            if (count == -1 || this.len != -1L && this.total >= this.len) {
                this.done();
                this.callback.onComplete(this.exchange, this.sender);
            } else {
                this.total += (long)count;
                buffer.flip();
                if (this.len > 0L && this.total > this.len) {
                    long limit = (long)count - (this.total - this.len);
                    buffer.limit((int)limit);
                }
                this.sender.send(buffer, (IoCallback)this);
            }
        }
        catch (IOException ex) {
            this.onException(this.exchange, this.sender, ex);
        }
    }

    public void onComplete(HttpServerExchange exchange, Sender sender) {
        if (exchange.isInIoThread()) {
            exchange.dispatch((Runnable)this);
        } else {
            this.run();
        }
    }

    public void onException(HttpServerExchange exchange, Sender sender, IOException ex) {
        this.done();
        this.callback.onException(exchange, sender, ex);
    }

    private void done() {
        this.pooled.close();
        this.pooled = null;
        IoUtils.safeClose((Closeable)this.source);
    }
}

