/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.utow;

import io.jooby.Context;
import io.jooby.Server;
import io.jooby.ServerSentEmitter;
import io.jooby.ServerSentMessage;
import io.jooby.SneakyThrows;
import io.jooby.internal.utow.UtowContext;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.XnioIoThread;

public class UtowSeverSentEmitter
implements ServerSentEmitter,
IoCallback {
    private Logger log = LoggerFactory.getLogger(ServerSentEmitter.class);
    private final UtowContext utow;
    private String id;
    private AtomicBoolean open = new AtomicBoolean(true);
    private SneakyThrows.Runnable closeTask;

    public UtowSeverSentEmitter(UtowContext utow) {
        this.utow = utow;
        this.id = UUID.randomUUID().toString();
    }

    @Nonnull
    public Context getContext() {
        return Context.readOnly((Context)this.utow);
    }

    @Nonnull
    public ServerSentEmitter send(ServerSentMessage data) {
        if (this.checkOpen()) {
            Sender sender = this.utow.exchange.getResponseSender();
            sender.send(ByteBuffer.wrap(data.toByteArray((Context)this.utow)), (IoCallback)this);
        } else {
            this.log.warn("server-sent-event closed: {}", (Object)this.id);
        }
        return this;
    }

    public ServerSentEmitter keepAlive(long timeInMillis) {
        if (this.checkOpen()) {
            XnioIoThread executor = this.utow.exchange.getIoThread();
            executor.executeAfter((Runnable)new ServerSentEmitter.KeepAlive((ServerSentEmitter)this, timeInMillis), timeInMillis, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public String getId() {
        return this.id;
    }

    public ServerSentEmitter setId(String id) {
        this.id = id;
        return this;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public void onClose(SneakyThrows.Runnable task) {
        this.closeTask = task;
    }

    @Nonnull
    public void close() {
        if (this.open.compareAndSet(true, false) && this.closeTask != null) {
            try {
                this.closeTask.run();
            }
            finally {
                this.utow.exchange.endExchange();
            }
        }
    }

    public void onComplete(HttpServerExchange exchange, Sender sender) {
    }

    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
        if (Server.connectionLost((Throwable)exception)) {
            this.close();
        } else {
            this.log.error("server-sent-event resulted in exception: id {} {}", new Object[]{this.id, this.utow.getRequestPath(), exception});
            if (SneakyThrows.isFatal((Throwable)exception)) {
                throw SneakyThrows.propagate((Throwable)exception);
            }
        }
    }

    private boolean checkOpen() {
        if (this.isOpen()) {
            if (this.utow.exchange.isComplete()) {
                this.close();
                return false;
            }
            return true;
        }
        return false;
    }
}

