/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.extension.core;

import io.jooby.internal.pebble.error.PebbleException;
import io.jooby.internal.pebble.extension.Filter;
import io.jooby.internal.pebble.extension.escaper.SafeString;
import io.jooby.internal.pebble.template.EvaluationContext;
import io.jooby.internal.pebble.template.PebbleTemplate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DateFilter
implements Filter {
    private final List<String> argumentNames = new ArrayList<String>();

    public DateFilter() {
        this.argumentNames.add("format");
        this.argumentNames.add("existingFormat");
        this.argumentNames.add("timeZone");
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        Locale locale = context.getLocale();
        String format = (String)args.get("format");
        String timeZone = (String)args.get("timeZone");
        if (TemporalAccessor.class.isAssignableFrom(input.getClass())) {
            return this.applyTemporal((TemporalAccessor)input, self, locale, lineNumber, format, timeZone);
        }
        return this.applyDate(input, self, locale, lineNumber, format, (String)args.get("existingFormat"), timeZone);
    }

    private Object applyDate(Object dateOrString, PebbleTemplate self, Locale locale, int lineNumber, String format, String existingFormatString, String timeZone) throws PebbleException {
        Date date;
        if (existingFormatString != null) {
            SimpleDateFormat existingFormat = new SimpleDateFormat(existingFormatString, locale);
            try {
                date = existingFormat.parse(dateOrString.toString());
            }
            catch (ParseException e) {
                throw new PebbleException(e, String.format("Could not parse the string '%s' into a date.", dateOrString.toString()), lineNumber, self.getName());
            }
        } else if (dateOrString instanceof Date) {
            date = (Date)dateOrString;
        } else if (dateOrString instanceof Number) {
            date = new Date(((Number)dateOrString).longValue());
        } else {
            throw new IllegalArgumentException(String.format("Unsupported argument type: %s (value: %s)", dateOrString.getClass().getName(), dateOrString));
        }
        SimpleDateFormat intendedFormat = new SimpleDateFormat(format == null ? "yyyy-MM-dd'T'HH:mm:ssZ" : format, locale);
        if (timeZone != null) {
            intendedFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        return new SafeString(intendedFormat.format(date));
    }

    private Object applyTemporal(TemporalAccessor input, PebbleTemplate self, Locale locale, int lineNumber, String format, String timeZone) throws PebbleException {
        DateTimeFormatter formatter = format != null ? DateTimeFormatter.ofPattern(format, locale) : DateTimeFormatter.ISO_DATE_TIME;
        ZoneId zoneId = this.getZoneId(input, timeZone);
        formatter = formatter.withZone(zoneId);
        try {
            return new SafeString(formatter.format(input));
        }
        catch (DateTimeException dte) {
            throw new PebbleException(dte, String.format("Could not format instance '%s' of type %s into a date.", input.toString(), input.getClass()), lineNumber, self.getName());
        }
    }

    private ZoneId getZoneId(TemporalAccessor input, String timeZone) {
        ZoneId zoneId = input.query(TemporalQueries.zone());
        if (zoneId == null && timeZone != null) {
            zoneId = ZoneId.of(timeZone);
        }
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return zoneId;
    }
}

