/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.extension.escaper;

import io.jooby.internal.pebble.error.PebbleException;
import io.jooby.internal.pebble.extension.Filter;
import io.jooby.internal.pebble.extension.escaper.EscapingStrategy;
import io.jooby.internal.pebble.extension.escaper.SafeString;
import io.jooby.internal.pebble.template.EvaluationContext;
import io.jooby.internal.pebble.template.PebbleTemplate;
import io.jooby.internal.pebble.unbescape.css.CssEscape;
import io.jooby.internal.pebble.unbescape.html.HtmlEscape;
import io.jooby.internal.pebble.unbescape.javascript.JavaScriptEscape;
import io.jooby.internal.pebble.unbescape.json.JsonEscape;
import io.jooby.internal.pebble.unbescape.uri.UriEscape;
import io.jooby.internal.pebble.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EscapeFilter
implements Filter {
    public static final String HTML_ESCAPE_STRATEGY = "html";
    public static final String JAVASCRIPT_ESCAPE_STRATEGY = "js";
    public static final String CSS_ESCAPE_STRATEGY = "css";
    public static final String URL_PARAM_ESCAPE_STRATEGY = "url_param";
    public static final String JSON_ESCAPE_STRATEGY = "json";
    private String defaultStrategy = "html";
    private final List<String> argumentNames = new ArrayList<String>();
    private final Map<String, EscapingStrategy> strategies = new HashMap<String, EscapingStrategy>();

    public EscapeFilter() {
        this.buildDefaultStrategies();
        this.argumentNames.add("strategy");
    }

    private void buildDefaultStrategies() {
        this.strategies.put(HTML_ESCAPE_STRATEGY, HtmlEscape::escapeHtml4Xml);
        this.strategies.put(JAVASCRIPT_ESCAPE_STRATEGY, JavaScriptEscape::escapeJavaScript);
        this.strategies.put(CSS_ESCAPE_STRATEGY, CssEscape::escapeCssIdentifier);
        this.strategies.put(URL_PARAM_ESCAPE_STRATEGY, UriEscape::escapeUriQueryParam);
        this.strategies.put(JSON_ESCAPE_STRATEGY, JsonEscape::escapeJson);
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object inputObject, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (inputObject == null || inputObject instanceof SafeString) {
            return inputObject;
        }
        String input = StringUtils.toString(inputObject);
        String strategy = this.defaultStrategy;
        if (args.get("strategy") != null) {
            strategy = (String)args.get("strategy");
        }
        if (!this.strategies.containsKey(strategy)) {
            throw new PebbleException(null, String.format("Unknown escaping strategy [%s]", strategy), lineNumber, self.getName());
        }
        return new SafeString(this.strategies.get(strategy).escape(input));
    }

    public String getDefaultStrategy() {
        return this.defaultStrategy;
    }

    public void setDefaultStrategy(String defaultStrategy) {
        this.defaultStrategy = defaultStrategy;
    }

    public void addEscapingStrategy(String name, EscapingStrategy strategy) {
        this.strategies.put(name, strategy);
    }
}

