/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.extension.escaper;

import io.jooby.internal.pebble.extension.AbstractNodeVisitor;
import io.jooby.internal.pebble.node.ArgumentsNode;
import io.jooby.internal.pebble.node.AutoEscapeNode;
import io.jooby.internal.pebble.node.NamedArgumentNode;
import io.jooby.internal.pebble.node.PrintNode;
import io.jooby.internal.pebble.node.expression.BlockFunctionExpression;
import io.jooby.internal.pebble.node.expression.ConcatenateExpression;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.node.expression.FilterExpression;
import io.jooby.internal.pebble.node.expression.FilterInvocationExpression;
import io.jooby.internal.pebble.node.expression.LiteralStringExpression;
import io.jooby.internal.pebble.node.expression.ParentFunctionExpression;
import io.jooby.internal.pebble.node.expression.TernaryExpression;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import java.util.ArrayList;
import java.util.LinkedList;

public class EscaperNodeVisitor
extends AbstractNodeVisitor {
    private final LinkedList<String> strategies = new LinkedList();
    private final LinkedList<Boolean> active = new LinkedList();

    public EscaperNodeVisitor(PebbleTemplateImpl template, boolean autoEscapting) {
        super(template);
        this.pushAutoEscapeState(autoEscapting);
    }

    @Override
    public void visit(PrintNode node) {
        Expression<?> expression = node.getExpression();
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            Expression<?> left = ternary.getExpression2();
            Expression<?> right = ternary.getExpression3();
            if (this.isUnsafe(left)) {
                ternary.setExpression2(this.escape(left));
            }
            if (this.isUnsafe(right)) {
                ternary.setExpression3(this.escape(right));
            }
        } else if (this.isUnsafe(expression)) {
            node.setExpression(this.escape(expression));
        }
    }

    @Override
    public void visit(AutoEscapeNode node) {
        this.active.push(node.isActive());
        this.strategies.push(node.getStrategy());
        node.getBody().accept(this);
        this.active.pop();
        this.strategies.pop();
    }

    private Expression<?> escape(Expression<?> expression) {
        ArrayList<NamedArgumentNode> namedArgs = new ArrayList<NamedArgumentNode>();
        if (!this.strategies.isEmpty() && this.strategies.peek() != null) {
            String strategy = this.strategies.peek();
            namedArgs.add(new NamedArgumentNode("strategy", new LiteralStringExpression(strategy, expression.getLineNumber())));
        }
        ArgumentsNode args = new ArgumentsNode(null, namedArgs, expression.getLineNumber());
        FilterInvocationExpression filter = new FilterInvocationExpression("escape", args, expression.getLineNumber());
        FilterExpression binary = new FilterExpression();
        binary.setLeft(expression);
        binary.setRight(filter);
        return binary;
    }

    private boolean isUnsafe(Expression<?> expression) {
        if (this.active.peek() == Boolean.FALSE) {
            return false;
        }
        boolean unsafe = true;
        if (expression instanceof LiteralStringExpression) {
            unsafe = false;
        } else if (expression instanceof ParentFunctionExpression || expression instanceof BlockFunctionExpression) {
            unsafe = false;
        } else if (this.isSafeConcatenateExpr(expression)) {
            unsafe = false;
        }
        return unsafe;
    }

    private boolean isSafeConcatenateExpr(Expression<?> expr) {
        if (!(expr instanceof ConcatenateExpression)) {
            return false;
        }
        ConcatenateExpression cexpr = (ConcatenateExpression)expr;
        return cexpr.getLeftExpression() instanceof LiteralStringExpression && cexpr.getRightExpression() instanceof LiteralStringExpression;
    }

    public void pushAutoEscapeState(boolean auto) {
        this.active.push(auto);
    }
}

