/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.extension.i18n;

import io.jooby.internal.pebble.extension.Function;
import io.jooby.internal.pebble.extension.i18n.UTF8Control;
import io.jooby.internal.pebble.template.EvaluationContext;
import io.jooby.internal.pebble.template.PebbleTemplate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class i18nFunction
implements Function {
    private final List<String> argumentNames = new ArrayList<String>();

    public i18nFunction() {
        this.argumentNames.add("bundle");
        this.argumentNames.add("key");
        this.argumentNames.add("params");
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
        String basename = (String)args.get("bundle");
        String key = (String)args.get("key");
        Object params = args.get("params");
        Locale locale = context.getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(basename, locale, new UTF8Control());
        Object phraseObject = bundle.getObject(key);
        if (params != null) {
            if (params instanceof List) {
                List list = (List)params;
                return MessageFormat.format(phraseObject.toString(), list.toArray());
            }
            return MessageFormat.format(phraseObject.toString(), params);
        }
        return phraseObject;
    }
}

