/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.lexer;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateSource
implements CharSequence {
    private final Logger logger = LoggerFactory.getLogger(TemplateSource.class);
    private char[] source;
    private int size = 0;
    private static final int DEFAULT_CAPACITY = 1024;
    private int offset = 0;
    private int lineNumber = 1;
    private final String filename;

    public TemplateSource(Reader reader, String filename) throws IOException {
        this.filename = filename;
        this.source = new char[1024];
        this.copyReaderIntoCharArray(reader);
    }

    private void copyReaderIntoCharArray(Reader reader) throws IOException {
        int amountJustRead;
        char[] buffer = new char[4096];
        while ((amountJustRead = reader.read(buffer)) != -1) {
            this.ensureCapacity(this.size + amountJustRead);
            this.append(buffer, amountJustRead);
        }
        reader.close();
    }

    private void append(char[] characters, int amount) {
        System.arraycopy(characters, 0, this.source, this.size, amount);
        this.size += amount;
    }

    private void ensureCapacity(int minCapacity) {
        if (this.source.length - minCapacity < 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.source.length;
        int newCapacity = Math.max(oldCapacity << 1, minCapacity);
        this.source = Arrays.copyOf(this.source, newCapacity);
    }

    public void advance(int amount) {
        this.logger.trace("Advancing amount: {}", (Object)amount);
        int index = 0;
        while (index < amount) {
            int sizeOfNewline = this.advanceThroughNewline(index);
            if (sizeOfNewline > 0) {
                index += sizeOfNewline;
                continue;
            }
            ++index;
        }
        this.size -= amount;
        this.offset += amount;
    }

    public void advanceThroughWhitespace() {
        int index = 0;
        while (Character.isWhitespace(this.charAt(index))) {
            int sizeOfNewline = this.advanceThroughNewline(index);
            if (sizeOfNewline > 0) {
                index += sizeOfNewline;
                continue;
            }
            ++index;
        }
        this.logger.trace("Advanced through {} characters of whitespace.", (Object)index);
        this.size -= index;
        this.offset += index;
    }

    private int advanceThroughNewline(int index) {
        char character = this.charAt(index);
        int numOfCharacters = 0;
        if ('\r' == character && '\n' == this.charAt(index + 1)) {
            ++this.lineNumber;
            numOfCharacters = 2;
        } else if ('\n' == character || '\r' == character || '\u0085' == character || '\u2028' == character || '\u2029' == character) {
            ++this.lineNumber;
            numOfCharacters = 1;
        }
        return numOfCharacters;
    }

    public String substring(int start, int end) {
        return new String(Arrays.copyOfRange(this.source, this.offset + start, this.offset + end));
    }

    public String substring(int end) {
        return new String(Arrays.copyOfRange(this.source, this.offset, this.offset + end));
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    public char charAt(int index) {
        return this.source[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new String(Arrays.copyOfRange(this.source, this.offset + start, this.offset + end));
    }

    @Override
    public String toString() {
        return new String(Arrays.copyOfRange(this.source, this.offset, this.offset + this.size));
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFilename() {
        return this.filename;
    }
}

