/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node;

import io.jooby.internal.pebble.extension.NodeVisitor;
import io.jooby.internal.pebble.node.AbstractRenderableNode;
import io.jooby.internal.pebble.node.ImportNode;
import io.jooby.internal.pebble.node.Node;
import io.jooby.internal.pebble.node.RenderableNode;
import io.jooby.internal.pebble.node.SetNode;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class BodyNode
extends AbstractRenderableNode {
    private final List<RenderableNode> children;
    private boolean onlyRenderInheritanceSafeNodes = false;
    private static List<Class<? extends Node>> nodesToRenderInChild = new ArrayList<Class<? extends Node>>();

    public BodyNode(int lineNumber, List<RenderableNode> children) {
        super(lineNumber);
        this.children = children;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) throws IOException {
        for (RenderableNode child : this.children) {
            if (this.onlyRenderInheritanceSafeNodes && context.getHierarchy().getParent() != null && !nodesToRenderInChild.contains(child.getClass())) continue;
            child.render(self, writer, context);
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<RenderableNode> getChildren() {
        return this.children;
    }

    public boolean isOnlyRenderInheritanceSafeNodes() {
        return this.onlyRenderInheritanceSafeNodes;
    }

    public void setOnlyRenderInheritanceSafeNodes(boolean onlyRenderInheritanceSafeNodes) {
        this.onlyRenderInheritanceSafeNodes = onlyRenderInheritanceSafeNodes;
    }

    static {
        nodesToRenderInChild.add(SetNode.class);
        nodesToRenderInChild.add(ImportNode.class);
    }
}

