/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node;

import io.jooby.internal.pebble.cache.CacheKey;
import io.jooby.internal.pebble.cache.PebbleCache;
import io.jooby.internal.pebble.error.PebbleException;
import io.jooby.internal.pebble.extension.NodeVisitor;
import io.jooby.internal.pebble.node.AbstractRenderableNode;
import io.jooby.internal.pebble.node.BodyNode;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import io.jooby.internal.pebble.utils.LimitedSizeWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.CompletionException;

public class CacheNode
extends AbstractRenderableNode {
    private final BodyNode body;
    private final Expression<?> name;

    public CacheNode(int lineNumber, Expression<?> name, BodyNode body) {
        super(lineNumber);
        this.body = body;
        this.name = name;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) throws IOException {
        try {
            PebbleCache<CacheKey, Object> tagCache = context.getTagCache();
            CacheKey key = new CacheKey(this, (String)this.name.evaluate(self, context), context.getLocale());
            String body = (String)context.getTagCache().computeIfAbsent(key, k -> {
                try {
                    return this.render(self, context);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            writer.write(body);
        }
        catch (CompletionException e) {
            throw new PebbleException(e, "Could not render cache block [" + this.name + "]");
        }
    }

    private String render(PebbleTemplateImpl self, EvaluationContextImpl context) throws IOException {
        Writer tempWriter = LimitedSizeWriter.from(new StringWriter(), context);
        this.body.render(self, tempWriter, context);
        return tempWriter.toString();
    }
}

