/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node;

import io.jooby.internal.pebble.error.PebbleException;
import io.jooby.internal.pebble.extension.NodeVisitor;
import io.jooby.internal.pebble.node.AbstractRenderableNode;
import io.jooby.internal.pebble.node.BodyNode;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import io.jooby.internal.pebble.utils.Pair;
import io.jooby.internal.pebble.utils.TypeUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class IfNode
extends AbstractRenderableNode {
    private final List<Pair<Expression<?>, BodyNode>> conditionsWithBodies;
    private final BodyNode elseBody;

    public IfNode(int lineNumber, List<Pair<Expression<?>, BodyNode>> conditionsWithBodies) {
        this(lineNumber, conditionsWithBodies, null);
    }

    public IfNode(int lineNumber, List<Pair<Expression<?>, BodyNode>> conditionsWithBodies, BodyNode elseBody) {
        super(lineNumber);
        this.conditionsWithBodies = conditionsWithBodies;
        this.elseBody = elseBody;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) throws IOException {
        boolean satisfied = false;
        for (Pair<Expression<?>, BodyNode> ifStatement : this.conditionsWithBodies) {
            Expression<?> conditionalExpression = ifStatement.getLeft();
            try {
                Object result = conditionalExpression.evaluate(self, context);
                if (result != null) {
                    if (!(result instanceof Boolean) && !(result instanceof Number) && !(result instanceof String)) throw new PebbleException(null, String.format("Unsupported value type %s. Expected Boolean, String, Number in \"if\" statement", result.getClass().getSimpleName()), this.getLineNumber(), self.getName());
                    satisfied = TypeUtils.compatibleCast(result, Boolean.class);
                } else if (context.isStrictVariables()) {
                    throw new PebbleException(null, "null value given to if statement and strict variables is set to true", this.getLineNumber(), self.getName());
                }
            }
            catch (RuntimeException ex) {
                throw new PebbleException(ex, "Wrong operand(s) type in conditional expression", this.getLineNumber(), self.getName());
            }
            if (!satisfied) continue;
            ifStatement.getRight().render(self, writer, context);
            break;
        }
        if (satisfied || this.elseBody == null) return;
        this.elseBody.render(self, writer, context);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<Pair<Expression<?>, BodyNode>> getConditionsWithBodies() {
        return this.conditionsWithBodies;
    }

    public BodyNode getElseBody() {
        return this.elseBody;
    }
}

