/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node;

import io.jooby.internal.pebble.error.PebbleException;
import io.jooby.internal.pebble.extension.NodeVisitor;
import io.jooby.internal.pebble.node.AbstractRenderableNode;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.node.expression.MapExpression;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;

public class IncludeNode
extends AbstractRenderableNode {
    private final Expression<?> includeExpression;
    private final MapExpression mapExpression;

    public IncludeNode(int lineNumber, Expression<?> includeExpression, MapExpression mapExpression) {
        super(lineNumber);
        this.includeExpression = includeExpression;
        this.mapExpression = mapExpression;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) throws IOException {
        String templateName = (String)this.includeExpression.evaluate(self, context);
        Object map = Collections.emptyMap();
        if (this.mapExpression != null) {
            map = this.mapExpression.evaluate(self, context);
        }
        if (templateName == null) {
            throw new PebbleException(null, "The template name in an include tag evaluated to NULL. If the template name is static, make sure to wrap it in quotes.", this.getLineNumber(), self.getName());
        }
        self.includeTemplate(writer, context, templateName, (Map<?, ?>)map);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public Expression<?> getIncludeExpression() {
        return this.includeExpression;
    }
}

