/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node;

import io.jooby.internal.pebble.extension.NodeVisitor;
import io.jooby.internal.pebble.node.AbstractRenderableNode;
import io.jooby.internal.pebble.node.ArgumentsNode;
import io.jooby.internal.pebble.node.BodyNode;
import io.jooby.internal.pebble.node.NamedArgumentNode;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.Macro;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import io.jooby.internal.pebble.template.ScopeChain;
import io.jooby.internal.pebble.utils.LimitedSizeWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MacroNode
extends AbstractRenderableNode {
    private final String name;
    private final ArgumentsNode args;
    private final BodyNode body;

    public MacroNode(String name, ArgumentsNode args, BodyNode body) {
        this.name = name;
        this.args = args;
        this.body = body;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) {
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public Macro getMacro() {
        return new Macro(){

            @Override
            public List<String> getArgumentNames() {
                ArrayList<String> names = new ArrayList<String>();
                for (NamedArgumentNode arg : MacroNode.this.getArgs().getNamedArgs()) {
                    names.add(arg.getName());
                }
                return names;
            }

            @Override
            public String getName() {
                return MacroNode.this.name;
            }

            @Override
            public String call(PebbleTemplateImpl self, EvaluationContextImpl context, Map<String, Object> macroArgs) {
                Writer writer = LimitedSizeWriter.from(new StringWriter(), context);
                ScopeChain scopeChain = context.getScopeChain();
                scopeChain.pushLocalScope();
                context.getExtensionRegistry().getGlobalVariables().forEach(scopeChain::put);
                for (NamedArgumentNode arg : MacroNode.this.getArgs().getNamedArgs()) {
                    Expression<?> valueExpression = arg.getValueExpression();
                    if (valueExpression == null) {
                        scopeChain.put(arg.getName(), null);
                        continue;
                    }
                    scopeChain.put(arg.getName(), arg.getValueExpression().evaluate(self, context));
                }
                scopeChain.pushScope(macroArgs);
                try {
                    MacroNode.this.getBody().render(self, writer, context);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not evaluate macro [" + MacroNode.this.name + "]", e);
                }
                scopeChain.popScope();
                scopeChain.popScope();
                return writer.toString();
            }
        };
    }

    public BodyNode getBody() {
        return this.body;
    }

    public ArgumentsNode getArgs() {
        return this.args;
    }

    public String getName() {
        return this.name;
    }
}

