/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node;

import io.jooby.internal.pebble.extension.NodeVisitor;
import io.jooby.internal.pebble.node.AbstractRenderableNode;
import io.jooby.internal.pebble.node.BodyNode;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import io.jooby.internal.pebble.utils.FutureWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelNode
extends AbstractRenderableNode {
    private final Logger logger = LoggerFactory.getLogger(ParallelNode.class);
    private final BodyNode body;
    private boolean hasWarnedAboutNonExistingExecutorService = false;

    public ParallelNode(int lineNumber, BodyNode body) {
        super(lineNumber);
        this.body = body;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) throws IOException {
        ExecutorService es = context.getExecutorService();
        if (es == null) {
            if (!this.hasWarnedAboutNonExistingExecutorService) {
                this.logger.info(String.format("The parallel tag was used [%s:%d] but no ExecutorService was provided. The parallel tag will be ignored and it's contents will be rendered in sequence with the rest of the template.", self.getName(), this.getLineNumber()));
                this.hasWarnedAboutNonExistingExecutorService = true;
            }
            this.body.render(self, writer, context);
        } else {
            EvaluationContextImpl contextCopy = context.threadSafeCopy(self);
            StringWriter newStringWriter = new StringWriter();
            FutureWriter newFutureWriter = new FutureWriter(newStringWriter);
            Future<String> future = es.submit(() -> {
                this.body.render(self, newFutureWriter, contextCopy);
                newFutureWriter.flush();
                newFutureWriter.close();
                return newStringWriter.toString();
            });
            ((FutureWriter)writer).enqueue(future);
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public BodyNode getBody() {
        return this.body;
    }
}

