/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node;

import io.jooby.internal.pebble.error.PebbleException;
import io.jooby.internal.pebble.extension.NodeVisitor;
import io.jooby.internal.pebble.extension.writer.SpecializedWriter;
import io.jooby.internal.pebble.extension.writer.StringWriterSpecializedAdapter;
import io.jooby.internal.pebble.node.AbstractRenderableNode;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import io.jooby.internal.pebble.utils.StringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class PrintNode
extends AbstractRenderableNode {
    private Expression<?> expression;

    public PrintNode(Expression<?> expression, int lineNumber) {
        super(lineNumber);
        this.expression = expression;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) throws IOException, PebbleException {
        Object var = this.expression.evaluate(self, context);
        if (var != null) {
            if (writer instanceof StringWriter) {
                new StringWriterSpecializedAdapter((StringWriter)writer).write(var);
            } else if (writer instanceof SpecializedWriter) {
                ((SpecializedWriter)((Object)writer)).write(var);
            } else {
                writer.write(StringUtils.toString(var));
            }
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public Expression<?> getExpression() {
        return this.expression;
    }

    public void setExpression(Expression<?> expression) {
        this.expression = expression;
    }
}

