/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node.expression;

import io.jooby.internal.pebble.error.PebbleException;
import io.jooby.internal.pebble.node.expression.BinaryExpression;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import io.jooby.internal.pebble.utils.TypeUtils;

public class AndExpression
extends BinaryExpression<Boolean> {
    @Override
    public Boolean evaluate(PebbleTemplateImpl self, EvaluationContextImpl context) {
        Expression<Boolean> leftExpression = this.getLeftExpression();
        boolean left = this.evaluateExpression(self, context, leftExpression);
        if (left) {
            Expression<Boolean> rightExpression = this.getRightExpression();
            return this.evaluateExpression(self, context, rightExpression);
        }
        return false;
    }

    private boolean evaluateExpression(PebbleTemplateImpl self, EvaluationContextImpl context, Expression<Boolean> expression) {
        Boolean evaluatedExpression = TypeUtils.compatibleCast(expression.evaluate(self, context), Boolean.class);
        if (evaluatedExpression == null) {
            if (context.isStrictVariables()) {
                throw new PebbleException(null, "null value used in and operator and strict variables is set to true", this.getLineNumber(), self.getName());
            }
            return false;
        }
        return evaluatedExpression;
    }
}

