/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node.expression;

import io.jooby.internal.pebble.extension.NodeVisitor;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArrayExpression
implements Expression<List<?>> {
    private final List<Expression<?>> values;
    private final int lineNumber;

    public ArrayExpression(int lineNumber) {
        this.values = Collections.emptyList();
        this.lineNumber = lineNumber;
    }

    public ArrayExpression(List<Expression<?>> values, int lineNumber) {
        this.values = values == null ? Collections.emptyList() : values;
        this.lineNumber = lineNumber;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<?> evaluate(PebbleTemplateImpl self, EvaluationContextImpl context) {
        ArrayList<Object> returnValues = new ArrayList<Object>(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            Expression<?> expr = this.values.get(i);
            Object value = expr == null ? null : (Object)expr.evaluate(self, context);
            returnValues.add(value);
        }
        return returnValues;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }
}

