/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node.expression;

import io.jooby.internal.pebble.error.AttributeNotFoundException;
import io.jooby.internal.pebble.error.PebbleException;
import io.jooby.internal.pebble.extension.Test;
import io.jooby.internal.pebble.extension.core.DefinedTest;
import io.jooby.internal.pebble.node.ArgumentsNode;
import io.jooby.internal.pebble.node.TestInvocationExpression;
import io.jooby.internal.pebble.node.expression.BinaryExpression;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import java.util.Map;

public class PositiveTestExpression
extends BinaryExpression<Object> {
    private Test cachedTest;

    @Override
    public Object evaluate(PebbleTemplateImpl self, EvaluationContextImpl context) {
        TestInvocationExpression testInvocation = (TestInvocationExpression)this.getRightExpression();
        ArgumentsNode args = testInvocation.getArgs();
        if (this.cachedTest == null) {
            String testName = testInvocation.getTestName();
            this.cachedTest = context.getExtensionRegistry().getTest(testInvocation.getTestName());
            if (this.cachedTest == null) {
                throw new PebbleException(null, String.format("Test [%s] does not exist.", testName), this.getLineNumber(), self.getName());
            }
        }
        Test test = this.cachedTest;
        Map<String, Object> namedArguments = args.getArgumentMap(self, context, test);
        if (test instanceof DefinedTest) {
            Object input = null;
            try {
                input = this.getLeftExpression().evaluate(self, context);
            }
            catch (AttributeNotFoundException e) {
                input = null;
            }
            return test.apply(input, namedArguments, self, context, this.getLineNumber());
        }
        return test.apply(this.getLeftExpression().evaluate(self, context), namedArguments, self, context, this.getLineNumber());
    }
}

