/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.node.expression;

import io.jooby.internal.pebble.error.PebbleException;
import io.jooby.internal.pebble.node.RenderableNode;
import io.jooby.internal.pebble.node.expression.UnaryExpression;
import io.jooby.internal.pebble.template.EvaluationContextImpl;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import io.jooby.internal.pebble.utils.LimitedSizeWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class RenderableNodeExpression
extends UnaryExpression {
    private final RenderableNode node;
    private final int lineNumber;

    public RenderableNodeExpression(RenderableNode node, int lineNumber) {
        this.node = node;
        this.lineNumber = lineNumber;
    }

    @Override
    public Object evaluate(PebbleTemplateImpl self, EvaluationContextImpl context) {
        Writer writer = LimitedSizeWriter.from(new StringWriter(), context);
        try {
            this.node.render(self, writer, context);
        }
        catch (IOException e) {
            throw new PebbleException(e, "Error occurred while rendering node", this.getLineNumber(), self.getName());
        }
        return writer.toString();
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }
}

