/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.parser;

import io.jooby.internal.pebble.error.ParserException;
import io.jooby.internal.pebble.lexer.Token;
import io.jooby.internal.pebble.lexer.TokenStream;
import io.jooby.internal.pebble.node.ArgumentsNode;
import io.jooby.internal.pebble.node.FunctionOrMacroNameNode;
import io.jooby.internal.pebble.node.NamedArgumentNode;
import io.jooby.internal.pebble.node.PositionalArgumentNode;
import io.jooby.internal.pebble.node.TestInvocationExpression;
import io.jooby.internal.pebble.node.expression.ArrayExpression;
import io.jooby.internal.pebble.node.expression.BinaryExpression;
import io.jooby.internal.pebble.node.expression.BlockFunctionExpression;
import io.jooby.internal.pebble.node.expression.ConcatenateExpression;
import io.jooby.internal.pebble.node.expression.ContextVariableExpression;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.node.expression.FilterInvocationExpression;
import io.jooby.internal.pebble.node.expression.FunctionOrMacroInvocationExpression;
import io.jooby.internal.pebble.node.expression.GetAttributeExpression;
import io.jooby.internal.pebble.node.expression.LiteralBigDecimalExpression;
import io.jooby.internal.pebble.node.expression.LiteralBooleanExpression;
import io.jooby.internal.pebble.node.expression.LiteralDoubleExpression;
import io.jooby.internal.pebble.node.expression.LiteralIntegerExpression;
import io.jooby.internal.pebble.node.expression.LiteralLongExpression;
import io.jooby.internal.pebble.node.expression.LiteralNullExpression;
import io.jooby.internal.pebble.node.expression.LiteralStringExpression;
import io.jooby.internal.pebble.node.expression.MapExpression;
import io.jooby.internal.pebble.node.expression.ParentFunctionExpression;
import io.jooby.internal.pebble.node.expression.TernaryExpression;
import io.jooby.internal.pebble.node.expression.UnaryExpression;
import io.jooby.internal.pebble.operator.Associativity;
import io.jooby.internal.pebble.operator.BinaryOperator;
import io.jooby.internal.pebble.operator.BinaryOperatorType;
import io.jooby.internal.pebble.operator.UnaryOperator;
import io.jooby.internal.pebble.parser.Parser;
import io.jooby.internal.pebble.parser.ParserOptions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExpressionParser {
    private static final Set<String> RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList("true", "false", "null", "none"));
    private final Parser parser;
    private TokenStream stream;
    private Map<String, BinaryOperator> binaryOperators;
    private Map<String, UnaryOperator> unaryOperators;
    private ParserOptions parserOptions;

    public ExpressionParser(Parser parser, Map<String, BinaryOperator> binaryOperators, Map<String, UnaryOperator> unaryOperators, ParserOptions parserOptions) {
        this.parser = parser;
        this.binaryOperators = binaryOperators;
        this.unaryOperators = unaryOperators;
        this.parserOptions = parserOptions;
    }

    public Expression<?> parseExpression() {
        return this.parseExpression(0);
    }

    private Expression<?> parseExpression(int minPrecedence) {
        Expression<Object> expression;
        Object operator;
        this.stream = this.parser.getStream();
        Token token = this.stream.current();
        if (this.isUnary(token)) {
            UnaryExpression unaryExpression;
            operator = this.unaryOperators.get(token.getValue());
            this.stream.next();
            expression = this.parseExpression(operator.getPrecedence());
            Class<? extends UnaryExpression> operatorNodeClass = operator.getNodeClass();
            try {
                unaryExpression = operatorNodeClass.newInstance();
                unaryExpression.setLineNumber(this.stream.current().getLineNumber());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            unaryExpression.setChildExpression(expression);
            expression = unaryExpression;
        } else if (token.test(Token.Type.PUNCTUATION, "(")) {
            this.stream.next();
            expression = this.parseExpression();
            this.stream.expect(Token.Type.PUNCTUATION, ")");
            expression = this.parsePostfixExpression(expression);
        } else {
            expression = token.test(Token.Type.PUNCTUATION, "[") ? this.parseArrayDefinitionExpression() : (token.test(Token.Type.PUNCTUATION, "{") ? this.parseMapDefinitionExpression() : this.subparseExpression());
        }
        token = this.stream.current();
        while (this.isBinary(token) && this.binaryOperators.get(token.getValue()).getPrecedence() >= minPrecedence) {
            BinaryExpression<Object> finalExpression;
            operator = this.binaryOperators.get(token.getValue());
            this.stream.next();
            Expression<Object> expressionRight = operator.getType() == BinaryOperatorType.FILTER ? this.parseFilterInvocationExpression() : (operator.getType() == BinaryOperatorType.TEST ? this.parseTestInvocationExpression() : this.parseExpression(Associativity.LEFT.equals((Object)operator.getAssociativity()) ? operator.getPrecedence() + 1 : operator.getPrecedence()));
            try {
                finalExpression = operator.getInstance();
            }
            catch (RuntimeException e) {
                throw new ParserException((Throwable)e, "Error instantiating operator node", token.getLineNumber(), this.stream.getFilename());
            }
            finalExpression.setLineNumber(this.stream.current().getLineNumber());
            finalExpression.setLeft(expression);
            finalExpression.setRight(expressionRight);
            expression = finalExpression;
            token = this.stream.current();
        }
        if (minPrecedence == 0) {
            return this.parseTernaryExpression(expression);
        }
        return expression;
    }

    private boolean isUnary(Token token) {
        return token.test(Token.Type.OPERATOR) && this.unaryOperators.containsKey(token.getValue());
    }

    private boolean isBinary(Token token) {
        return token.test(Token.Type.OPERATOR) && this.binaryOperators.containsKey(token.getValue());
    }

    private Expression<?> subparseExpression() {
        Expression<Long> node;
        Token token = this.stream.current();
        block0 : switch (token.getType()) {
            case NAME: {
                switch (token.getValue()) {
                    case "true": 
                    case "TRUE": {
                        node = new LiteralBooleanExpression(true, token.getLineNumber());
                        this.stream.next();
                        break block0;
                    }
                    case "false": 
                    case "FALSE": {
                        node = new LiteralBooleanExpression(false, token.getLineNumber());
                        this.stream.next();
                        break block0;
                    }
                    case "none": 
                    case "NONE": 
                    case "null": 
                    case "NULL": {
                        node = new LiteralNullExpression(token.getLineNumber());
                        this.stream.next();
                        break block0;
                    }
                }
                node = this.stream.peek().test(Token.Type.PUNCTUATION, "(") ? new FunctionOrMacroNameNode(token.getValue(), this.stream.peek().getLineNumber()) : new ContextVariableExpression(token.getValue(), token.getLineNumber());
                this.stream.next();
                break;
            }
            case LONG: {
                String longValue = token.getValue();
                node = new LiteralLongExpression(Long.valueOf(longValue), token.getLineNumber());
                this.stream.next();
                break;
            }
            case NUMBER: {
                String numberValue = token.getValue();
                node = this.parserOptions.isLiteralNumbersAsBigDecimals() ? new LiteralBigDecimalExpression(new BigDecimal(numberValue), token.getLineNumber()) : (numberValue.contains(".") ? new LiteralDoubleExpression(Double.valueOf(numberValue), token.getLineNumber()) : (this.parserOptions.isLiteralDecimalTreatedAsInteger() ? new LiteralIntegerExpression(Integer.valueOf(numberValue), token.getLineNumber()) : new LiteralLongExpression(Long.valueOf(numberValue), token.getLineNumber())));
                this.stream.next();
                break;
            }
            case STRING: 
            case STRING_INTERPOLATION_START: {
                node = this.parseStringExpression();
                break;
            }
            default: {
                throw new ParserException(null, String.format("Unexpected token \"%s\" of value \"%s\"", token.getType().toString(), token.getValue()), token.getLineNumber(), this.stream.getFilename());
            }
        }
        return this.parsePostfixExpression(node);
    }

    private Expression<?> parseStringExpression() throws ParserException {
        ConcatenateExpression firstExpr;
        ArrayList nodes = new ArrayList();
        Token.Type previousNodeType = null;
        while (true) {
            if (this.stream.current().test(Token.Type.STRING) && Token.Type.STRING != previousNodeType) {
                Token token = this.stream.expect(Token.Type.STRING);
                nodes.add(new LiteralStringExpression(token.getValue(), token.getLineNumber()));
                previousNodeType = Token.Type.STRING;
                continue;
            }
            if (!this.stream.current().test(Token.Type.STRING_INTERPOLATION_START)) break;
            this.stream.expect(Token.Type.STRING_INTERPOLATION_START);
            nodes.add(this.parseExpression());
            this.stream.expect(Token.Type.STRING_INTERPOLATION_END);
            previousNodeType = Token.Type.STRING_INTERPOLATION_END;
        }
        Expression first = (Expression)nodes.remove(0);
        if (nodes.isEmpty()) {
            return first;
        }
        ConcatenateExpression expr = firstExpr = new ConcatenateExpression(first, null);
        for (int i = 0; i < nodes.size(); ++i) {
            Expression node = (Expression)nodes.get(i);
            if (i == nodes.size() - 1) {
                expr.setRight(node);
                continue;
            }
            ConcatenateExpression newExpr = new ConcatenateExpression(node, null);
            expr.setRight(newExpr);
            expr = newExpr;
        }
        return firstExpr;
    }

    private Expression<?> parseTernaryExpression(Expression<?> expression) {
        if (!this.stream.current().test(Token.Type.PUNCTUATION, "?")) {
            return expression;
        }
        this.stream.next();
        Expression<?> expression2 = this.parseExpression();
        this.stream.expect(Token.Type.PUNCTUATION, ":");
        Expression<?> expression3 = this.parseExpression();
        expression = new TernaryExpression(expression, expression2, expression3, this.stream.current().getLineNumber(), this.stream.getFilename());
        return expression;
    }

    private Expression<?> parsePostfixExpression(Expression<?> node) {
        while (true) {
            Token current;
            if ((current = this.stream.current()).test(Token.Type.PUNCTUATION, ".") || current.test(Token.Type.PUNCTUATION, "[")) {
                node = this.parseBeanAttributeExpression(node);
                continue;
            }
            if (!current.test(Token.Type.PUNCTUATION, "(")) break;
            node = this.parseFunctionOrMacroInvocation(node);
        }
        return node;
    }

    private Expression<?> parseFunctionOrMacroInvocation(Expression<?> node) {
        String functionName = ((FunctionOrMacroNameNode)node).getName();
        ArgumentsNode args = this.parseArguments();
        switch (functionName) {
            case "parent": {
                return new ParentFunctionExpression(this.parser.peekBlockStack(), this.stream.current().getLineNumber());
            }
            case "block": {
                return new BlockFunctionExpression(args, node.getLineNumber());
            }
        }
        return new FunctionOrMacroInvocationExpression(functionName, args, node.getLineNumber());
    }

    public FilterInvocationExpression parseFilterInvocationExpression() {
        TokenStream stream = this.parser.getStream();
        Token filterToken = stream.expect(Token.Type.NAME);
        ArgumentsNode args = stream.current().test(Token.Type.PUNCTUATION, "(") ? this.parseArguments() : new ArgumentsNode(null, null, filterToken.getLineNumber());
        return new FilterInvocationExpression(filterToken.getValue(), args, filterToken.getLineNumber());
    }

    private Expression<?> parseTestInvocationExpression() {
        TokenStream stream = this.parser.getStream();
        int lineNumber = stream.current().getLineNumber();
        Token testToken = stream.expect(Token.Type.NAME);
        ArgumentsNode args = stream.current().test(Token.Type.PUNCTUATION, "(") ? this.parseArguments() : new ArgumentsNode(null, null, testToken.getLineNumber());
        return new TestInvocationExpression(lineNumber, testToken.getValue(), args);
    }

    private Expression<?> parseBeanAttributeExpression(Expression<?> node) {
        TokenStream stream = this.parser.getStream();
        if (stream.current().test(Token.Type.PUNCTUATION, ".")) {
            stream.next();
            Token token = stream.expect(Token.Type.NAME);
            ArgumentsNode args = null;
            if (stream.current().test(Token.Type.PUNCTUATION, "(") && !(args = this.parseArguments()).getNamedArgs().isEmpty()) {
                throw new ParserException(null, "Can not use named arguments when calling a bean method", stream.current().getLineNumber(), stream.getFilename());
            }
            node = new GetAttributeExpression(node, new LiteralStringExpression(token.getValue(), token.getLineNumber()), args, stream.getFilename(), token.getLineNumber());
        } else if (stream.current().test(Token.Type.PUNCTUATION, "[")) {
            stream.next();
            node = new GetAttributeExpression(node, this.parseExpression(), stream.getFilename(), stream.current().getLineNumber());
            stream.expect(Token.Type.PUNCTUATION, "]");
        }
        return node;
    }

    private ArgumentsNode parseArguments() {
        return this.parseArguments(false);
    }

    public ArgumentsNode parseArguments(boolean isMacroDefinition) {
        ArrayList<PositionalArgumentNode> positionalArgs = new ArrayList<PositionalArgumentNode>();
        ArrayList<NamedArgumentNode> namedArgs = new ArrayList<NamedArgumentNode>();
        this.stream = this.parser.getStream();
        this.stream.expect(Token.Type.PUNCTUATION, "(");
        while (!this.stream.current().test(Token.Type.PUNCTUATION, ")")) {
            String argumentName = null;
            Expression<?> argumentValue = null;
            if (!namedArgs.isEmpty() || !positionalArgs.isEmpty()) {
                this.stream.expect(Token.Type.PUNCTUATION, ",");
            }
            if (isMacroDefinition) {
                argumentName = this.parseNewVariableName();
                if (this.stream.current().test(Token.Type.PUNCTUATION, "=")) {
                    this.stream.expect(Token.Type.PUNCTUATION, "=");
                    argumentValue = this.parseExpression();
                }
            } else {
                if (this.stream.peek().test(Token.Type.PUNCTUATION, "=")) {
                    argumentName = this.parseNewVariableName();
                    this.stream.expect(Token.Type.PUNCTUATION, "=");
                }
                argumentValue = this.parseExpression();
            }
            if (argumentName == null) {
                if (!namedArgs.isEmpty()) {
                    throw new ParserException(null, "Positional arguments must be declared before any named arguments.", this.stream.current().getLineNumber(), this.stream.getFilename());
                }
                positionalArgs.add(new PositionalArgumentNode(argumentValue));
                continue;
            }
            namedArgs.add(new NamedArgumentNode(argumentName, argumentValue));
        }
        this.stream.expect(Token.Type.PUNCTUATION, ")");
        return new ArgumentsNode(positionalArgs, namedArgs, this.stream.current().getLineNumber());
    }

    public String parseNewVariableName() {
        this.stream = this.parser.getStream();
        Token token = this.stream.expect(Token.Type.NAME);
        if (RESERVED_KEYWORDS.contains(token.getValue())) {
            throw new ParserException(null, String.format("Can not assign a value to %s", token.getValue()), token.getLineNumber(), this.stream.getFilename());
        }
        return token.getValue();
    }

    private Expression<?> parseArrayDefinitionExpression() {
        TokenStream stream = this.parser.getStream();
        stream.expect(Token.Type.PUNCTUATION, "[");
        if (stream.current().test(Token.Type.PUNCTUATION, "]")) {
            stream.next();
            return new ArrayExpression(stream.current().getLineNumber());
        }
        ArrayList elements = new ArrayList();
        while (true) {
            Expression<?> expr = this.parseExpression();
            elements.add(expr);
            if (stream.current().test(Token.Type.PUNCTUATION, "]")) break;
            stream.expect(Token.Type.PUNCTUATION, ",");
        }
        stream.expect(Token.Type.PUNCTUATION, "]");
        return new ArrayExpression(elements, stream.current().getLineNumber());
    }

    private Expression<?> parseMapDefinitionExpression() {
        TokenStream stream = this.parser.getStream();
        stream.expect(Token.Type.PUNCTUATION, "{");
        if (stream.current().test(Token.Type.PUNCTUATION, "}")) {
            stream.next();
            return new MapExpression(stream.current().getLineNumber());
        }
        HashMap elements = new HashMap();
        while (true) {
            Expression<?> keyExpr = this.parseExpression();
            stream.expect(Token.Type.PUNCTUATION, ":");
            Expression<?> valueExpr = this.parseExpression();
            elements.put(keyExpr, valueExpr);
            if (stream.current().test(Token.Type.PUNCTUATION, "}")) break;
            stream.expect(Token.Type.PUNCTUATION, ",");
        }
        stream.expect(Token.Type.PUNCTUATION, "}");
        return new MapExpression(elements, stream.current().getLineNumber());
    }
}

