/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.parser;

import io.jooby.internal.pebble.error.ParserException;
import io.jooby.internal.pebble.lexer.Token;
import io.jooby.internal.pebble.lexer.TokenStream;
import io.jooby.internal.pebble.node.BodyNode;
import io.jooby.internal.pebble.node.PrintNode;
import io.jooby.internal.pebble.node.RenderableNode;
import io.jooby.internal.pebble.node.RootNode;
import io.jooby.internal.pebble.node.TextNode;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.operator.BinaryOperator;
import io.jooby.internal.pebble.operator.UnaryOperator;
import io.jooby.internal.pebble.parser.ExpressionParser;
import io.jooby.internal.pebble.parser.Parser;
import io.jooby.internal.pebble.parser.ParserOptions;
import io.jooby.internal.pebble.parser.StoppingCondition;
import io.jooby.internal.pebble.tokenParser.TokenParser;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;

public class ParserImpl
implements Parser {
    private final Map<String, BinaryOperator> binaryOperators;
    private final Map<String, UnaryOperator> unaryOperators;
    private final Map<String, TokenParser> tokenParsers;
    private ExpressionParser expressionParser;
    private TokenStream stream;
    private LinkedList<String> blockStack;
    private ParserOptions parserOptions;

    public ParserImpl(Map<String, UnaryOperator> unaryOperators, Map<String, BinaryOperator> binaryOperators, Map<String, TokenParser> tokenParsers, ParserOptions parserOptions) {
        this.binaryOperators = binaryOperators;
        this.unaryOperators = unaryOperators;
        this.tokenParsers = tokenParsers;
        this.parserOptions = parserOptions;
    }

    @Override
    public RootNode parse(TokenStream stream) {
        this.expressionParser = new ExpressionParser(this, this.binaryOperators, this.unaryOperators, this.parserOptions);
        this.stream = stream;
        this.blockStack = new LinkedList();
        BodyNode body = this.subparse();
        return new RootNode(body);
    }

    @Override
    public BodyNode subparse() {
        return this.subparse(null);
    }

    @Override
    public BodyNode subparse(StoppingCondition stopCondition) {
        ArrayList<RenderableNode> nodes = new ArrayList<RenderableNode>();
        block5: while (!this.stream.isEOF()) {
            switch (this.stream.current().getType()) {
                case TEXT: {
                    Token token = this.stream.current();
                    nodes.add(new TextNode(token.getValue(), token.getLineNumber()));
                    this.stream.next();
                    continue block5;
                }
                case PRINT_START: {
                    Token token = this.stream.next();
                    Expression<?> expression = this.expressionParser.parseExpression();
                    nodes.add(new PrintNode(expression, token.getLineNumber()));
                    this.stream.expect(Token.Type.PRINT_END);
                    continue block5;
                }
                case EXECUTE_START: {
                    this.stream.next();
                    Token token = this.stream.current();
                    if (!Token.Type.NAME.equals((Object)token.getType())) {
                        throw new ParserException(null, "A block must start with a tag name.", token.getLineNumber(), this.stream.getFilename());
                    }
                    if (stopCondition != null && stopCondition.evaluate(token)) {
                        return new BodyNode(token.getLineNumber(), nodes);
                    }
                    TokenParser tokenParser = this.tokenParsers.get(token.getValue());
                    if (tokenParser == null) {
                        throw new ParserException(null, String.format("Unexpected tag name \"%s\"", token.getValue()), token.getLineNumber(), this.stream.getFilename());
                    }
                    RenderableNode node = tokenParser.parse(token, this);
                    if (node == null) continue block5;
                    nodes.add(node);
                    continue block5;
                }
            }
            throw new ParserException(null, "Parser ended in undefined state.", this.stream.current().getLineNumber(), this.stream.getFilename());
        }
        return new BodyNode(this.stream.current().getLineNumber(), nodes);
    }

    @Override
    public TokenStream getStream() {
        return this.stream;
    }

    public void setStream(TokenStream stream) {
        this.stream = stream;
    }

    @Override
    public ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    @Override
    public String peekBlockStack() {
        return this.blockStack.peek();
    }

    @Override
    public String popBlockStack() {
        return this.blockStack.pop();
    }

    @Override
    public void pushBlockStack(String blockName) {
        this.blockStack.push(blockName);
    }
}

