/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.template;

import io.jooby.internal.pebble.cache.CacheKey;
import io.jooby.internal.pebble.cache.PebbleCache;
import io.jooby.internal.pebble.error.PebbleException;
import io.jooby.internal.pebble.extension.ExtensionRegistry;
import io.jooby.internal.pebble.template.EvaluationContext;
import io.jooby.internal.pebble.template.EvaluationOptions;
import io.jooby.internal.pebble.template.Hierarchy;
import io.jooby.internal.pebble.template.PebbleTemplateImpl;
import io.jooby.internal.pebble.template.RenderedSizeContext;
import io.jooby.internal.pebble.template.ScopeChain;
import io.jooby.internal.pebble.utils.Callbacks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class EvaluationContextImpl
implements EvaluationContext,
RenderedSizeContext {
    private final boolean strictVariables;
    private final Hierarchy hierarchy;
    private final ScopeChain scopeChain;
    private final Locale locale;
    private final int maxRenderedSize;
    private final ExtensionRegistry extensionRegistry;
    private final PebbleCache<CacheKey, Object> tagCache;
    private final ExecutorService executorService;
    private final List<PebbleTemplateImpl> importedTemplates;
    private final Map<String, PebbleTemplateImpl> namedImportedTemplates;
    private final EvaluationOptions evaluationOptions;
    private final AtomicInteger charsRendered = new AtomicInteger();

    public EvaluationContextImpl(PebbleTemplateImpl self, boolean strictVariables, Locale locale, int maxRenderedSize, ExtensionRegistry extensionRegistry, PebbleCache<CacheKey, Object> tagCache, ExecutorService executorService, List<PebbleTemplateImpl> importedTemplates, Map<String, PebbleTemplateImpl> namedImportedTemplates, ScopeChain scopeChain, Hierarchy hierarchy, EvaluationOptions evaluationOptions) {
        if (hierarchy == null) {
            hierarchy = new Hierarchy(self);
        }
        this.strictVariables = strictVariables;
        this.locale = locale;
        this.maxRenderedSize = maxRenderedSize;
        this.extensionRegistry = extensionRegistry;
        this.tagCache = tagCache;
        this.executorService = executorService;
        this.importedTemplates = importedTemplates;
        this.namedImportedTemplates = namedImportedTemplates;
        this.scopeChain = scopeChain;
        this.hierarchy = hierarchy;
        this.evaluationOptions = evaluationOptions;
    }

    public EvaluationContextImpl shallowCopyWithoutInheritanceChain(PebbleTemplateImpl self) {
        EvaluationContextImpl result = new EvaluationContextImpl(self, this.strictVariables, this.locale, this.maxRenderedSize, this.extensionRegistry, this.tagCache, this.executorService, this.importedTemplates, this.namedImportedTemplates, this.scopeChain, null, this.evaluationOptions);
        return result;
    }

    public EvaluationContextImpl threadSafeCopy(PebbleTemplateImpl self) {
        EvaluationContextImpl result = new EvaluationContextImpl(self, this.strictVariables, this.locale, this.maxRenderedSize, this.extensionRegistry, this.tagCache, this.executorService, new ArrayList<PebbleTemplateImpl>(this.importedTemplates), new HashMap<String, PebbleTemplateImpl>(this.namedImportedTemplates), this.scopeChain.deepCopy(), this.hierarchy, this.evaluationOptions);
        return result;
    }

    public PebbleTemplateImpl getNamedImportedTemplate(String alias) {
        return this.namedImportedTemplates.get(alias);
    }

    public void addNamedImportedTemplates(String alias, PebbleTemplateImpl template) {
        if (this.namedImportedTemplates.containsKey(alias)) {
            throw new PebbleException(null, "More than one named template can not share the same name: " + alias);
        }
        this.namedImportedTemplates.put(alias, template);
    }

    @Override
    public boolean isStrictVariables() {
        return this.strictVariables;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public int getMaxRenderedSize() {
        return this.maxRenderedSize;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public List<PebbleTemplateImpl> getImportedTemplates() {
        return this.importedTemplates;
    }

    public PebbleCache<CacheKey, Object> getTagCache() {
        return this.tagCache;
    }

    public ScopeChain getScopeChain() {
        return this.scopeChain;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public EvaluationOptions getEvaluationOptions() {
        return this.evaluationOptions;
    }

    @Override
    public Object getVariable(String key) {
        return this.scopeChain.get(key);
    }

    private void pushScope(EvaluationContextImpl newContext, Map<?, ?> additionalVariables, Callbacks.PebbleConsumer<EvaluationContextImpl> scopedFunction) throws IOException {
        ScopeChain scopeChain = newContext.getScopeChain();
        scopeChain.pushScope();
        if (additionalVariables != null) {
            for (Map.Entry<?, ?> entry : additionalVariables.entrySet()) {
                scopeChain.put((String)entry.getKey(), entry.getValue());
            }
        }
        scopedFunction.accept(newContext);
        scopeChain.popScope();
    }

    public void scopedShallowWithoutInheritanceChain(PebbleTemplateImpl template, Map<?, ?> additionalVariables, Callbacks.PebbleConsumer<EvaluationContextImpl> scopedFunction) throws IOException {
        this.pushScope(this.shallowCopyWithoutInheritanceChain(template), additionalVariables, scopedFunction);
    }

    @Override
    public int addAndGet(int delta) {
        return this.charsRendered.addAndGet(delta);
    }
}

