/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.tokenParser;

import io.jooby.internal.pebble.error.ParserException;
import io.jooby.internal.pebble.lexer.Token;
import io.jooby.internal.pebble.lexer.TokenStream;
import io.jooby.internal.pebble.node.BlockNode;
import io.jooby.internal.pebble.node.BodyNode;
import io.jooby.internal.pebble.node.RenderableNode;
import io.jooby.internal.pebble.parser.Parser;
import io.jooby.internal.pebble.tokenParser.TokenParser;

public class BlockTokenParser
implements TokenParser {
    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        Token blockName = stream.next();
        if (!blockName.test(Token.Type.NAME) && !blockName.test(Token.Type.STRING)) {
            stream.expect(Token.Type.NAME);
        }
        String name = blockName.getValue();
        stream.next();
        stream.expect(Token.Type.EXECUTE_END);
        parser.pushBlockStack(name);
        BodyNode blockBody = parser.subparse(tkn -> tkn.test(Token.Type.NAME, "endblock"));
        parser.popBlockStack();
        Token endblock = stream.current();
        if (!endblock.test(Token.Type.NAME, "endblock")) {
            throw new ParserException(null, "endblock tag should be present with block tag starting line number ", token.getLineNumber(), stream.getFilename());
        }
        stream.next();
        Token current = stream.current();
        if (current.test(Token.Type.NAME, name) || current.test(Token.Type.STRING, name)) {
            stream.next();
        }
        stream.expect(Token.Type.EXECUTE_END);
        return new BlockNode(lineNumber, name, blockBody);
    }

    @Override
    public String getTag() {
        return "block";
    }
}

