/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.tokenParser;

import io.jooby.internal.pebble.lexer.Token;
import io.jooby.internal.pebble.lexer.TokenStream;
import io.jooby.internal.pebble.node.BodyNode;
import io.jooby.internal.pebble.node.PrintNode;
import io.jooby.internal.pebble.node.RenderableNode;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.node.expression.FilterExpression;
import io.jooby.internal.pebble.node.expression.FilterInvocationExpression;
import io.jooby.internal.pebble.node.expression.RenderableNodeExpression;
import io.jooby.internal.pebble.parser.Parser;
import io.jooby.internal.pebble.tokenParser.TokenParser;
import java.util.ArrayList;

public class FilterTokenParser
implements TokenParser {
    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        ArrayList<FilterInvocationExpression> filterInvocationExpressions = new ArrayList<FilterInvocationExpression>();
        filterInvocationExpressions.add(parser.getExpressionParser().parseFilterInvocationExpression());
        while (stream.current().test(Token.Type.OPERATOR, "|")) {
            stream.next();
            filterInvocationExpressions.add(parser.getExpressionParser().parseFilterInvocationExpression());
        }
        stream.expect(Token.Type.EXECUTE_END);
        BodyNode body = parser.subparse(tkn -> tkn.test(Token.Type.NAME, "endfilter"));
        stream.next();
        stream.expect(Token.Type.EXECUTE_END);
        Expression<Object> lastExpression = new RenderableNodeExpression(body, stream.current().getLineNumber());
        for (Expression expression : filterInvocationExpressions) {
            FilterExpression filterExpression = new FilterExpression();
            filterExpression.setRight(expression);
            filterExpression.setLeft(lastExpression);
            lastExpression = filterExpression;
        }
        return new PrintNode(lastExpression, lineNumber);
    }

    @Override
    public String getTag() {
        return "filter";
    }
}

