/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.tokenParser;

import io.jooby.internal.pebble.error.ParserException;
import io.jooby.internal.pebble.lexer.Token;
import io.jooby.internal.pebble.lexer.TokenStream;
import io.jooby.internal.pebble.node.FromNode;
import io.jooby.internal.pebble.node.RenderableNode;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.parser.Parser;
import io.jooby.internal.pebble.tokenParser.TokenParser;
import io.jooby.internal.pebble.utils.Pair;
import java.util.ArrayList;
import java.util.List;

public class FromTokenParser
implements TokenParser {
    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        Expression<?> fromExpression = parser.getExpressionParser().parseExpression();
        List<Pair<String, String>> namedMacros = this.parseNamedMacros(parser);
        stream.expect(Token.Type.EXECUTE_END);
        return new FromNode(lineNumber, fromExpression, namedMacros);
    }

    private List<Pair<String, String>> parseNamedMacros(Parser parser) {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        TokenStream stream = parser.getStream();
        stream.expect(Token.Type.NAME, "import");
        while (!stream.current().getType().equals((Object)Token.Type.EXECUTE_END)) {
            Token pre = stream.expect(Token.Type.NAME);
            if (stream.current().test(Token.Type.NAME, "as")) {
                stream.next();
                Token post = stream.expect(Token.Type.NAME);
                pairs.add(new Pair<String, String>(post.getValue(), pre.getValue()));
            } else {
                pairs.add(new Pair<String, String>(pre.getValue(), pre.getValue()));
            }
            Token token = stream.current();
            if (token.test(Token.Type.PUNCTUATION, ",")) {
                stream.next();
                continue;
            }
            if (token.getType().equals((Object)Token.Type.EXECUTE_END)) break;
            String message = String.format("Unexpected token of value \"%s\" and type %s, expected token of type %s or ',' ", new Object[]{token.getValue(), token.getType().toString(), Token.Type.EXECUTE_END});
            throw new ParserException(null, message, token.getLineNumber(), stream.getFilename());
        }
        return pairs;
    }

    @Override
    public String getTag() {
        return "from";
    }
}

