/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.tokenParser;

import io.jooby.internal.pebble.error.ParserException;
import io.jooby.internal.pebble.lexer.Token;
import io.jooby.internal.pebble.lexer.TokenStream;
import io.jooby.internal.pebble.node.BodyNode;
import io.jooby.internal.pebble.node.IfNode;
import io.jooby.internal.pebble.node.RenderableNode;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.parser.Parser;
import io.jooby.internal.pebble.parser.StoppingCondition;
import io.jooby.internal.pebble.tokenParser.TokenParser;
import io.jooby.internal.pebble.utils.Pair;
import java.util.ArrayList;

public class IfTokenParser
implements TokenParser {
    private static final StoppingCondition DECIDE_IF_FORK = token -> token.test(Token.Type.NAME, "elseif", "else", "endif");

    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        ArrayList conditionsWithBodies = new ArrayList();
        Expression<?> expression = parser.getExpressionParser().parseExpression();
        stream.expect(Token.Type.EXECUTE_END);
        BodyNode body = parser.subparse(DECIDE_IF_FORK);
        conditionsWithBodies.add(new Pair(expression, body));
        BodyNode elseBody = null;
        boolean end = false;
        block10: while (!end) {
            if (stream.current().getValue() == null) {
                throw new ParserException(null, "Unexpected end of template. Pebble was looking for the \"endif\" tag", stream.current().getLineNumber(), stream.getFilename());
            }
            switch (stream.current().getValue()) {
                case "else": {
                    stream.next();
                    stream.expect(Token.Type.EXECUTE_END);
                    elseBody = parser.subparse(tkn -> tkn.test(Token.Type.NAME, "endif"));
                    continue block10;
                }
                case "elseif": {
                    stream.next();
                    expression = parser.getExpressionParser().parseExpression();
                    stream.expect(Token.Type.EXECUTE_END);
                    body = parser.subparse(DECIDE_IF_FORK);
                    conditionsWithBodies.add(new Pair(expression, body));
                    continue block10;
                }
                case "endif": {
                    stream.next();
                    end = true;
                    continue block10;
                }
            }
            throw new ParserException(null, "Unexpected end of template. Pebble was looking for the following tags \"else\", \"elseif\", or \"endif\"", stream.current().getLineNumber(), stream.getFilename());
        }
        stream.expect(Token.Type.EXECUTE_END);
        return new IfNode(lineNumber, conditionsWithBodies, elseBody);
    }

    @Override
    public String getTag() {
        return "if";
    }
}

