/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.pebble.tokenParser;

import io.jooby.internal.pebble.error.ParserException;
import io.jooby.internal.pebble.lexer.Token;
import io.jooby.internal.pebble.lexer.TokenStream;
import io.jooby.internal.pebble.node.IncludeNode;
import io.jooby.internal.pebble.node.RenderableNode;
import io.jooby.internal.pebble.node.expression.Expression;
import io.jooby.internal.pebble.node.expression.MapExpression;
import io.jooby.internal.pebble.parser.Parser;
import io.jooby.internal.pebble.tokenParser.TokenParser;

public class IncludeTokenParser
implements TokenParser {
    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        Expression<?> includeExpression = parser.getExpressionParser().parseExpression();
        Token current = stream.current();
        MapExpression mapExpression = null;
        if (current.getType().equals((Object)Token.Type.NAME) && current.getValue().equals("with")) {
            stream.next();
            Expression<?> parsedExpression = parser.getExpressionParser().parseExpression();
            if (parsedExpression instanceof MapExpression) {
                mapExpression = (MapExpression)parsedExpression;
            } else {
                throw new ParserException(null, String.format("Unexpected expression '%1s'.", parsedExpression.getClass().getCanonicalName()), token.getLineNumber(), stream.getFilename());
            }
        }
        stream.expect(Token.Type.EXECUTE_END);
        return new IncludeNode(lineNumber, includeExpression, mapExpression);
    }

    @Override
    public String getTag() {
        return "include";
    }
}

