/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.whoops;

import io.jooby.internal.whoops.SourceLocator;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Frame {
    private static final int SAMPLE_SIZE = 10;
    private String fileName;
    private String methodName;
    private int lineStart;
    private int line;
    private String location;
    private String source;
    private boolean open;
    private String className;
    private List<Throwable> comments;

    private Frame() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getLine() {
        return this.line;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getClassName() {
        return this.className;
    }

    public List<Throwable> getComments() {
        return this.comments;
    }

    public boolean hasSource() {
        return this.source != null && this.source.length() > 0;
    }

    public static List<Frame> toFrames(SourceLocator locator, Throwable cause) {
        LinkedList<Throwable> causalChain = Frame.getCausalChain(cause);
        Throwable head = causalChain.getLast();
        List frames = causalChain.stream().filter(it -> it != head).map(it -> Frame.toFrame(locator, it, it.getStackTrace()[0])).collect(Collectors.toList());
        Stream.of(head.getStackTrace()).map(e -> Frame.toFrame(locator, head, e)).forEach(frames::add);
        return frames.stream().filter(Frame::hasSource).collect(Collectors.toList());
    }

    static Frame toFrame(SourceLocator locator, Throwable cause, StackTraceElement e) {
        int line = Math.max(e.getLineNumber(), 1);
        String className = Optional.ofNullable(e.getClassName()).orElse("~unknown");
        String[] names = className.split("\\.");
        String filename = Optional.ofNullable(e.getFileName()).orElse(names[names.length - 1]);
        StringBuilder path = new StringBuilder();
        Stream.of(names).limit(names.length - 1).forEach(it -> path.append((String)it).append(File.separator));
        path.append(names[names.length - 1]);
        SourceLocator.Source source = locator.source(path.toString());
        SourceLocator.Preview preview = source.preview(line, 10);
        Frame frame = new Frame();
        frame.fileName = filename;
        frame.methodName = Optional.ofNullable(e.getMethodName()).orElse("~unknown");
        frame.lineStart = preview.getLineStart();
        frame.line = line;
        frame.location = Files.exists(source.getPath(), new LinkOption[0]) ? locator.getBasedir().relativize(source.getPath()).toString() : filename;
        frame.source = preview.getCode();
        frame.open = false;
        frame.className = className.replaceAll("\\$\\d+", "");
        frame.comments = Collections.singletonList(cause);
        return frame;
    }

    private static LinkedList<Throwable> getCausalChain(Throwable throwable) {
        Throwable cause;
        LinkedList<Throwable> causes = new LinkedList<Throwable>();
        causes.add(throwable);
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            causes.add(throwable);
            if (throwable == slowPointer) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return causes;
    }
}

