/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.whoops;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceLocator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Path basedir;
    private Map<String, Source> sources = new ConcurrentHashMap<String, Source>();

    public SourceLocator(Path basedir) {
        this.basedir = basedir;
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public Source source(String filename) {
        return this.sources.computeIfAbsent(filename, f -> {
            final Set skip = Stream.of("target", "bin", "build", "tmp", "temp", "node_modules", "node").collect(Collectors.toSet());
            try {
                final List<String> files = Arrays.asList(filename, filename.replace(".", File.separator) + ".java", filename.replace(".", File.separator) + ".kt", filename.replace(".", File.separator) + "Kt.kt");
                final ArrayList<Path> source = new ArrayList<Path>();
                source.add(Paths.get(filename, new String[0]));
                this.log.debug("scanning {}", (Object)this.basedir);
                Files.walkFileTree(this.basedir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        String dirName = dir.getFileName().toString();
                        if (Files.isHidden(dir) || dirName.startsWith(".")) {
                            SourceLocator.this.log.debug("skipping hidden directory: {}", (Object)dir);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (skip.contains(dirName)) {
                            SourceLocator.this.log.debug("skipping binary directory: {}", (Object)dir);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        SourceLocator.this.log.debug("found directory: {}", (Object)dir);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        return files.stream().filter(f -> file.toString().endsWith((String)f)).findFirst().map(f -> {
                            source.add(0, file.toAbsolutePath());
                            return FileVisitResult.TERMINATE;
                        }).orElse(FileVisitResult.CONTINUE);
                    }
                });
                Source source2 = new Source((Path)source.get(0));
                return source2;
            }
            catch (IOException x) {
                Source source = new Source(Paths.get(filename, new String[0]));
                return source;
            }
            finally {
                this.log.debug("done scanning {}", (Object)this.basedir);
            }
        });
    }

    public static class Source {
        private static final int[] RANGE = new int[]{0, 0};
        private final Path path;

        public Source(Path path) {
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public Preview preview(int line, int size) {
            List<String> lines = this.getLines();
            int[] range = this.range(line, size, lines.size());
            int from = range[0];
            int to = range[1];
            String code = from >= 0 && to <= lines.size() ? lines.subList(from, to).stream().map(l -> l.length() == 0 ? " " : l).collect(Collectors.joining("\n")) : "";
            return new Preview(code, from + 1);
        }

        private int[] range(int line, int size, int totalSize) {
            if (line < totalSize) {
                int from = Math.max(line - size, 0);
                int toset = Math.max(line - from - size, 0);
                int to = Math.min(from + toset + size * 2, totalSize);
                int fromset = Math.abs(to - line - size);
                from = Math.max(from - fromset, 0);
                return new int[]{from, to};
            }
            return RANGE;
        }

        private List<String> getLines() {
            try {
                return Files.readAllLines(this.path, StandardCharsets.UTF_8);
            }
            catch (IOException x) {
                return Collections.emptyList();
            }
        }

        public String toString() {
            return this.path.toString();
        }
    }

    public static class Preview {
        private String code;
        private int line;

        public Preview(String code, int line) {
            this.code = code;
            this.line = line;
        }

        public int getLineStart() {
            return this.line;
        }

        public String getCode() {
            return this.code;
        }
    }
}

