/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.whoops;

import com.typesafe.config.Config;
import io.jooby.ErrorHandler;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.internal.whoops.Whoops;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;

public class WhoopsModule
implements Extension {
    private static final String ENABLED = "whoops.enabled";
    private Path basedir;

    public WhoopsModule(@Nonnull Path basedir) {
        this.basedir = basedir;
    }

    public WhoopsModule() {
        this(Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    public void install(@Nonnull Jooby application) {
        boolean enabled;
        Config config = application.getConfig();
        boolean bl = enabled = config.hasPath(ENABLED) ? config.getBoolean(ENABLED) : application.getEnvironment().isActive("dev", new String[]{"test"});
        if (enabled) {
            Whoops whoops = new Whoops(this.basedir, application.getLog());
            application.assets("/whoops/*", this.getClass().getPackage().getName().replace(".", "/"));
            application.error((ErrorHandler)whoops);
        } else {
            application.getLog().debug("Whoops is disabled");
        }
    }
}

