/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.http;

import io.joshworks.restclient.http.HttpDeleteWithBody;
import io.joshworks.restclient.http.HttpMethod;
import io.joshworks.restclient.http.HttpOptionsWithBody;
import io.joshworks.restclient.http.HttpPatchWithBody;
import io.joshworks.restclient.http.HttpResponse;
import io.joshworks.restclient.http.async.Callback;
import io.joshworks.restclient.http.exceptions.RestClientException;
import io.joshworks.restclient.request.HttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.entity.NByteArrayEntity;

public class ClientRequest {
    private final CloseableHttpClient syncClient;
    private final CloseableHttpAsyncClient asyncClient;
    private final Map<String, Object> defaultHeaders;
    public final String url;
    public final HttpMethod httpMethod;
    private static final String USER_AGENT = "rest-client/1.6.0";

    ClientRequest(HttpMethod httpMethod, String url, CloseableHttpClient syncClient, CloseableHttpAsyncClient asyncClient, Map<String, Object> defaultHeaders) {
        this.url = url;
        this.httpMethod = httpMethod;
        this.syncClient = syncClient;
        this.asyncClient = asyncClient;
        this.defaultHeaders = defaultHeaders;
    }

    private <T> FutureCallback<org.apache.http.HttpResponse> prepareCallback(final Class<T> responseClass, final Callback<T> callback) {
        if (callback == null) {
            return null;
        }
        return new FutureCallback<org.apache.http.HttpResponse>(){

            public void cancelled() {
                callback.cancelled();
            }

            public void completed(org.apache.http.HttpResponse arg0) {
                callback.completed(new HttpResponse(arg0, responseClass));
            }

            public void failed(Exception arg0) {
                callback.failed(arg0);
            }
        };
    }

    public <T> CompletableFuture<HttpResponse<T>> requestAsync(HttpRequest httpRequest, Class<T> responseClass) {
        HttpRequestBase requestObj = this.prepareRequest(httpRequest, true);
        if (this.asyncClient == null) {
            throw new RestClientException("Async client not configured");
        }
        if (!this.asyncClient.isRunning()) {
            this.asyncClient.start();
        }
        final CompletableFuture<HttpResponse<T>> completableFuture = new CompletableFuture<HttpResponse<T>>();
        this.asyncClient.execute((HttpUriRequest)requestObj, this.prepareCallback(responseClass, new Callback<T>(){

            @Override
            public void completed(HttpResponse<T> httpResponse) {
                completableFuture.complete(httpResponse);
            }

            @Override
            public void failed(Exception e) {
                completableFuture.completeExceptionally(e);
            }

            @Override
            public void cancelled() {
            }
        }));
        return completableFuture;
    }

    public <T> Future<HttpResponse<T>> requestAsync(HttpRequest httpRequest, final Class<T> responseClass, Callback<T> callback) {
        HttpRequestBase requestObj = this.prepareRequest(httpRequest, true);
        if (this.asyncClient == null) {
            throw new RestClientException("Async client not configured");
        }
        if (!this.asyncClient.isRunning()) {
            this.asyncClient.start();
        }
        final Future future = this.asyncClient.execute((HttpUriRequest)requestObj, this.prepareCallback(responseClass, callback));
        return new Future<HttpResponse<T>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public HttpResponse<T> get() throws InterruptedException, ExecutionException {
                return this.getResponse();
            }

            @Override
            public HttpResponse<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.getResponse(timeout, unit);
            }

            private HttpResponse<T> getResponse() throws ExecutionException, InterruptedException {
                org.apache.http.HttpResponse httpResponse = (org.apache.http.HttpResponse)future.get();
                return new HttpResponse(httpResponse, responseClass);
            }

            private HttpResponse<T> getResponse(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
                org.apache.http.HttpResponse httpResponse = (org.apache.http.HttpResponse)future.get(timeout, unit);
                return new HttpResponse(httpResponse, responseClass);
            }
        };
    }

    public <T> HttpResponse<T> request(HttpRequest httpRequest, Class<T> responseClass) {
        if (this.syncClient == null) {
            throw new RestClientException("Sync client not configured");
        }
        HttpRequestBase requestObj = this.prepareRequest(httpRequest, false);
        try {
            CloseableHttpResponse response = this.syncClient.execute((HttpUriRequest)requestObj);
            return HttpResponse.create(requestObj, (org.apache.http.HttpResponse)response, responseClass);
        }
        catch (Exception e) {
            throw new RestClientException(e);
        }
    }

    private HttpRequestBase prepareRequest(HttpRequest httpRequest, boolean async) {
        String urlToRequest;
        if (this.defaultHeaders != null) {
            for (Map.Entry<String, Object> entry : this.defaultHeaders.entrySet()) {
                if (entry.getKey().equalsIgnoreCase("Content-Type") && httpRequest.body() != null && httpRequest.body().implicitContentType()) continue;
                httpRequest.header(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        if (!httpRequest.getHeaders().containsKey("User-Agent")) {
            httpRequest.header("User-Agent", USER_AGENT);
        }
        if (!httpRequest.getHeaders().containsKey("Accept-Encoding")) {
            httpRequest.header("Accept-Encoding", "gzip");
        }
        try {
            URL reqUrl = new URL(httpRequest.getUrl());
            URI uri = new URI(reqUrl.getProtocol(), reqUrl.getUserInfo(), reqUrl.getHost(), reqUrl.getPort(), URLDecoder.decode(reqUrl.getPath(), StandardCharsets.UTF_8.name()), "", reqUrl.getRef());
            urlToRequest = uri.toURL().toString();
            if (reqUrl.getQuery() != null && !reqUrl.getQuery().trim().equals("")) {
                if (!urlToRequest.substring(urlToRequest.length() - 1).equals("?")) {
                    urlToRequest = urlToRequest + "?";
                }
                urlToRequest = urlToRequest + reqUrl.getQuery();
            } else if (urlToRequest.substring(urlToRequest.length() - 1).equals("?")) {
                urlToRequest = urlToRequest.substring(0, urlToRequest.length() - 1);
            }
        }
        catch (Exception e) {
            throw new RestClientException(e);
        }
        Object reqObj = null;
        switch (httpRequest.getHttpMethod()) {
            case GET: {
                reqObj = new HttpGet(urlToRequest);
                break;
            }
            case POST: {
                reqObj = new HttpPost(urlToRequest);
                break;
            }
            case PUT: {
                reqObj = new HttpPut(urlToRequest);
                break;
            }
            case DELETE: {
                reqObj = new HttpDeleteWithBody(urlToRequest);
                break;
            }
            case PATCH: {
                reqObj = new HttpPatchWithBody(urlToRequest);
                break;
            }
            case OPTIONS: {
                reqObj = new HttpOptionsWithBody(urlToRequest);
                break;
            }
            case HEAD: {
                reqObj = new HttpHead(urlToRequest);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid HTTP method: " + (Object)((Object)httpRequest.getHttpMethod()));
            }
        }
        for (Map.Entry entry : httpRequest.getHeaders().entrySet()) {
            List values = (List)entry.getValue();
            if (values == null) continue;
            for (String value : values) {
                reqObj.addHeader((String)entry.getKey(), value);
            }
        }
        if (httpRequest.getHttpMethod() != HttpMethod.GET && httpRequest.getHttpMethod() != HttpMethod.HEAD && httpRequest.body() != null) {
            HttpEntity entity = httpRequest.body().getEntity();
            if (async) {
                if (reqObj.getHeaders("Content-Type") == null || reqObj.getHeaders("Content-Type").length == 0) {
                    reqObj.setHeader(entity.getContentType());
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    entity.writeTo((OutputStream)byteArrayOutputStream);
                    NByteArrayEntity en = new NByteArrayEntity(byteArrayOutputStream.toByteArray());
                    ((HttpEntityEnclosingRequestBase)reqObj).setEntity((HttpEntity)en);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            } else {
                ((HttpEntityEnclosingRequestBase)reqObj).setEntity(entity);
            }
        }
        return reqObj;
    }
}

