/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.http;

import io.joshworks.restclient.http.Headers;
import io.joshworks.restclient.http.HttpStreamResponse;
import io.joshworks.restclient.http.Json;
import io.joshworks.restclient.http.MediaType;
import io.joshworks.restclient.http.exceptions.RestClientException;
import io.joshworks.restclient.http.mapper.ObjectMapper;
import io.joshworks.restclient.http.mapper.ObjectMappers;
import io.joshworks.restclient.http.utils.ResponseUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;

public class HttpResponse<T>
implements Closeable {
    private final int statusCode;
    private final String statusText;
    private final Headers headers;
    protected final InputStream rawBody;
    private final Class<T> responseClass;
    private byte[] cached;

    HttpResponse(org.apache.http.HttpResponse response, Class<T> responseClass) {
        this.headers = this.responseHeaders(response);
        this.rawBody = this.consumeBody(response);
        this.responseClass = responseClass;
        StatusLine statusLine = response.getStatusLine();
        if (statusLine != null) {
            this.statusCode = statusLine.getStatusCode();
            this.statusText = statusLine.getReasonPhrase();
        } else {
            this.statusCode = -1;
            this.statusText = "NOT_SET";
        }
    }

    public static <T> HttpResponse<T> create(HttpRequestBase request, org.apache.http.HttpResponse response, Class<T> responseClass) {
        if (responseClass == InputStream.class) {
            return new HttpStreamResponse<T>(response, responseClass, request);
        }
        return new HttpResponse<T>(response, responseClass);
    }

    protected InputStream consumeBody(org.apache.http.HttpResponse response) {
        HttpEntity responseEntity = response.getEntity();
        try {
            if (responseEntity != null) {
                InputStream entity = this.getEntity(responseEntity);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ResponseUtils.readBytes(entity));
                return byteArrayInputStream;
            }
            InputStream entity = null;
            return entity;
        }
        catch (IOException ex) {
            throw new RestClientException(ex);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)responseEntity);
        }
    }

    private InputStream getEntity(HttpEntity responseEntity) throws IOException {
        if (ResponseUtils.isGzipped(responseEntity.getContentEncoding()) && responseEntity.getContentLength() > 0L) {
            return new GZIPInputStream(responseEntity.getContent());
        }
        return responseEntity.getContent();
    }

    private Headers responseHeaders(org.apache.http.HttpResponse response) {
        Header[] allHeaders;
        Headers headers = new Headers();
        for (Header header : allHeaders = response.getAllHeaders()) {
            String headerName = header.getName();
            ArrayList<String> list = (ArrayList<String>)headers.get(headerName);
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(header.getValue());
            headers.put(headerName, list);
        }
        return headers;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public boolean isSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300 || this.statusCode == 304;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public InputStream getRawBody() {
        if (this.cached != null) {
            return new ByteArrayInputStream(this.cached);
        }
        return this.rawBody;
    }

    public <E> E bodyAs(Class<E> type) {
        return this.getObjectMapper().readValue(this.asString(), type);
    }

    public String asString() {
        return this.readBodyAsString();
    }

    public T body() {
        return this.parseBody(this.responseClass);
    }

    private T parseBody(Class<T> type) {
        if (InputStream.class.equals(type)) {
            if (this.cached != null) {
                return (T)new ByteArrayInputStream(this.cached);
            }
            return (T)this.rawBody;
        }
        String bodyString = this.readBodyAsString();
        if (Json.class.equals(type)) {
            return (T)new Json(bodyString);
        }
        if (String.class.equals(type)) {
            return (T)bodyString;
        }
        return this.getObjectMapper().readValue(bodyString, type);
    }

    private String readBodyAsString() {
        try {
            if (this.rawBody == null && this.cached == null) {
                return null;
            }
            if (this.cached == null) {
                this.cached = ResponseUtils.readBytes(this.rawBody);
                this.rawBody.close();
            }
            String charset = this.getCharset();
            return new String(this.cached, charset);
        }
        catch (IOException e) {
            throw new RestClientException(e);
        }
    }

    private String getCharset() {
        String responseCharset;
        String charset = StandardCharsets.UTF_8.name();
        String contentType = this.headers.getFirst("Content-Type");
        if (contentType != null && (responseCharset = ResponseUtils.getCharsetFromContentType(contentType)) != null && !responseCharset.trim().equals("")) {
            charset = responseCharset;
        }
        return charset;
    }

    private ObjectMapper getObjectMapper() {
        String contentType = this.headers.getFirst("Content-Type");
        if (contentType == null) {
            throw new RestClientException("Response Content-Type header not found");
        }
        MediaType mediaType = MediaType.valueOf(contentType);
        ObjectMapper mapper = ObjectMappers.getMapper(mediaType);
        if (mapper == null) {
            throw new RestClientException("No ObjectMapper found for response with Content-Type: " + contentType);
        }
        return mapper;
    }

    @Override
    public void close() {
        if (this.rawBody != null) {
            try {
                this.rawBody.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

