/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.http;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.joshworks.restclient.http.exceptions.JsonParsingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Json {
    private static Gson gson = new Gson();
    private JSONObject jsonObject;
    private JSONArray jsonArray;
    private final String json;
    private boolean array;

    public Json(String json) {
        this.json = json;
        if (json == null || "".equals(json.trim())) {
            this.jsonObject = new JSONObject();
        } else {
            try {
                this.jsonObject = new JSONObject(json);
            }
            catch (JSONException e) {
                try {
                    this.jsonArray = new JSONArray(json);
                    this.array = true;
                }
                catch (JSONException e1) {
                    throw new JsonParsingException("Failed to parse " + json, e1);
                }
            }
        }
    }

    public JSONObject getObject() {
        return this.jsonObject;
    }

    public JSONArray getArray() {
        JSONArray result = this.jsonArray;
        if (!this.array) {
            result = new JSONArray();
            result.put((Object)this.jsonObject);
        }
        return result;
    }

    public boolean isArray() {
        return this.array;
    }

    public <T> T as(Class<T> type) {
        if (this.json == null) {
            return null;
        }
        return (T)gson.fromJson(this.json, type);
    }

    public <T> List<T> asListOf(Class<T> type) {
        if (this.json == null) {
            return new ArrayList();
        }
        return (List)gson.fromJson(this.json, new TypedList<T>(type));
    }

    public Map<String, Object> asMap() {
        if (this.json == null) {
            return new HashMap<String, Object>();
        }
        return (Map)gson.fromJson(this.json, new TypeToken<Map<String, Object>>(){}.getType());
    }

    public String toString() {
        if (this.isArray()) {
            if (this.jsonArray == null) {
                return null;
            }
            return this.jsonArray.toString();
        }
        if (this.jsonObject == null) {
            return "";
        }
        return this.jsonObject.toString();
    }

    public static class TypedList<T>
    implements ParameterizedType {
        private Class<?> wrapped;

        public TypedList(Class<T> wrapper) {
            this.wrapped = wrapper;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.wrapped};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }
}

