/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.http;

import io.joshworks.restclient.http.utils.MimeMappings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;

public class MediaType {
    public static final String MEDIA_TYPE_WILDCARD = "*";
    public static final String WILDCARD = "*/*";
    public static final MediaType WILDCARD_TYPE = new MediaType();
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType APPLICATION_XML_TYPE = new MediaType("application", "xml");
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MediaType APPLICATION_ATOM_XML_TYPE = new MediaType("application", "atom+xml");
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final MediaType APPLICATION_XHTML_XML_TYPE = new MediaType("application", "xhtml+xml");
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final MediaType APPLICATION_SVG_XML_TYPE = new MediaType("application", "svg+xml");
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType APPLICATION_JSON_TYPE = new MediaType("application", "json");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_FORM_URLENCODED_TYPE = new MediaType("application", "x-www-form-urlencoded");
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MULTIPART_FORM_DATA_TYPE = new MediaType("multipart", "form-data");
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MediaType APPLICATION_OCTET_STREAM_TYPE = new MediaType("application", "octet-stream");
    public static final String TEXT_PLAIN = "text/plain";
    public static final MediaType TEXT_PLAIN_TYPE = new MediaType("text", "plain");
    public static final String TEXT_XML = "text/xml";
    public static final MediaType TEXT_XML_TYPE = new MediaType("text", "xml");
    public static final String TEXT_HTML = "text/html";
    public static final MediaType TEXT_HTML_TYPE = new MediaType("text", "html");
    private static final String SUBTYPE_SEPARATOR = "/";
    private static final String PARAMETERS_SEPARATOR = ";";
    private static MimeMappings mimeMappings = MimeMappings.builder().build();
    private String type;
    private String subtype;
    private Map<String, String> parameters = new HashMap<String, String>();

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type == null ? MEDIA_TYPE_WILDCARD : type;
        String string = this.subtype = subtype == null ? MEDIA_TYPE_WILDCARD : subtype;
        if (parameters == null) {
            this.parameters = new HashMap<String, String>();
        } else {
            TreeMap<String, String> map = new TreeMap<String, String>(String::compareToIgnoreCase);
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                map.put(e.getKey().toLowerCase(), e.getValue());
            }
            this.parameters = Collections.unmodifiableMap(map);
        }
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, new HashMap<String, String>());
    }

    public MediaType() {
        this(MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD);
    }

    public static MediaType valueOf(String type) throws IllegalArgumentException {
        String mimeType;
        if (type == null || type.trim().isEmpty() || type.startsWith(SUBTYPE_SEPARATOR) || type.endsWith(SUBTYPE_SEPARATOR)) {
            throw new IllegalArgumentException("Invalid mime type '" + type + "'");
        }
        String[] splitType = type.split(SUBTYPE_SEPARATOR);
        if (splitType.length == 2) {
            MediaType.nonEmpty(type, splitType[0]);
            MediaType.nonEmpty(type, splitType[1]);
            Map<String, String> parameters = new HashMap<String, String>();
            String subType = splitType[1];
            if (splitType[1].contains(PARAMETERS_SEPARATOR)) {
                String[] subTypeWithparameter = splitType[1].split(PARAMETERS_SEPARATOR);
                String paramString = subTypeWithparameter[1].trim();
                subType = subTypeWithparameter[0];
                parameters = MediaType.parseParameters(paramString);
            }
            return new MediaType(splitType[0].trim(), subType.trim(), parameters);
        }
        if (!type.contains(SUBTYPE_SEPARATOR) && (mimeType = mimeMappings.getMimeType(type)) != null) {
            return MediaType.valueOf(mimeType);
        }
        throw new IllegalArgumentException("Invalid mime type '" + type + "'");
    }

    private static void nonEmpty(String original, String val) throws IllegalArgumentException {
        if (val == null || val.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid mime type '" + original + "'");
        }
        if (val.length() - val.replace(SUBTYPE_SEPARATOR, "").length() > 0) {
            throw new IllegalArgumentException("Invalid mime type '" + original + "'");
        }
    }

    private static Map<String, String> parseParameters(String paramString) {
        String[] split;
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String kv : split = paramString.split(" ")) {
            String[] keyValue = kv.split("=");
            if (keyValue.length != 2) continue;
            parameters.put(keyValue[0], keyValue[1]);
        }
        return parameters;
    }

    public static MediaType getMimeForFile(String fileExtension) {
        if (fileExtension == null || fileExtension.isEmpty()) {
            return APPLICATION_OCTET_STREAM_TYPE;
        }
        String mimeType = mimeMappings.getMimeType(fileExtension);
        if (mimeType == null || mimeType.isEmpty()) {
            return APPLICATION_OCTET_STREAM_TYPE;
        }
        try {
            return MediaType.valueOf(mimeType);
        }
        catch (Exception e) {
            return APPLICATION_OCTET_STREAM_TYPE;
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return this.getType().equals(MEDIA_TYPE_WILDCARD);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return this.getSubtype().equals(MEDIA_TYPE_WILDCARD);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isCompatible(MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.type.equals(MEDIA_TYPE_WILDCARD) || other.type.equals(MEDIA_TYPE_WILDCARD)) {
            return true;
        }
        if (this.type.equalsIgnoreCase(other.type) && (this.subtype.equals(MEDIA_TYPE_WILDCARD) || other.subtype.equals(MEDIA_TYPE_WILDCARD))) {
            return true;
        }
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode() + this.parameters.hashCode();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(" ");
        for (Map.Entry<String, String> kv : this.parameters.entrySet()) {
            joiner.add(kv.getKey() + "=" + kv.getValue());
        }
        String params = joiner.toString();
        String type = this.type + SUBTYPE_SEPARATOR + this.subtype;
        return params != null && !params.isEmpty() ? type + "; " + params : type;
    }
}

