/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.http;

import io.joshworks.restclient.http.ClientBuilder;
import io.joshworks.restclient.http.ClientContainer;
import io.joshworks.restclient.http.ClientRequest;
import io.joshworks.restclient.http.HttpMethod;
import io.joshworks.restclient.http.utils.ClientStats;
import io.joshworks.restclient.request.GetRequest;
import io.joshworks.restclient.request.HttpRequestWithBody;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.http.client.CookieStore;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;

public class RestClient
implements Closeable {
    private static final int IDLE_CONNECTION_TIMEOUT = 30;
    public final String id;
    private final Function<String, String> urlTransformer;
    private final String baseUrl;
    private final PoolingNHttpClientConnectionManager asyncConnectionManager;
    private final PoolingHttpClientConnectionManager syncConnectionManager;
    private final Map<String, Object> defaultHeaders = new HashMap<String, Object>();
    private final CloseableHttpAsyncClient asyncClient;
    private final CloseableHttpClient syncClient;
    private final CookieStore cookieStore;

    RestClient(String baseUrl, Map<String, Object> defaultHeaders, Function<String, String> urlTransformer, PoolingNHttpClientConnectionManager asyncConnectionManager, PoolingHttpClientConnectionManager syncConnectionManager, CloseableHttpAsyncClient asyncClient, CloseableHttpClient syncClient, CookieStore cookieStore) {
        this.baseUrl = baseUrl;
        this.urlTransformer = urlTransformer;
        this.asyncConnectionManager = asyncConnectionManager;
        this.syncConnectionManager = syncConnectionManager;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        this.cookieStore = cookieStore;
        this.defaultHeaders.putAll(defaultHeaders);
        this.id = this.newUUID();
    }

    private RestClient(HttpClientBuilder clientBuilder, HttpAsyncClientBuilder asyncClientBuilder) {
        this.id = this.newUUID();
        this.baseUrl = "";
        this.urlTransformer = url -> url;
        this.cookieStore = new BasicCookieStore();
        if (clientBuilder != null) {
            this.syncConnectionManager = new PoolingHttpClientConnectionManager();
            clientBuilder.setConnectionManager((HttpClientConnectionManager)this.syncConnectionManager);
            clientBuilder.setDefaultCookieStore(this.cookieStore);
            this.syncClient = clientBuilder.build();
        } else {
            this.syncClient = null;
            this.syncConnectionManager = null;
        }
        if (asyncClientBuilder != null) {
            try {
                PoolingNHttpClientConnectionManager asyncConnManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor());
                asyncClientBuilder.setConnectionManager((NHttpClientConnectionManager)asyncConnManager);
                asyncClientBuilder.setDefaultCookieStore(this.cookieStore);
                this.asyncClient = asyncClientBuilder.build();
                this.asyncConnectionManager = asyncConnManager;
            }
            catch (IOReactorException e) {
                throw new IllegalStateException("Failed to Async IO reactor", e);
            }
        } else {
            this.asyncClient = null;
            this.asyncConnectionManager = null;
        }
    }

    public static ClientBuilder builder() {
        return new ClientBuilder();
    }

    public static RestClient with(HttpClientBuilder clientBuilder) {
        return RestClient.with(clientBuilder, null);
    }

    public static RestClient with(HttpClientBuilder clientBuilder, HttpAsyncClientBuilder asyncClientBuilder) {
        return new RestClient(clientBuilder, asyncClientBuilder);
    }

    public GetRequest get(String ... url) {
        return new GetRequest(new ClientRequest(HttpMethod.GET, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public GetRequest head(String ... url) {
        return new GetRequest(new ClientRequest(HttpMethod.HEAD, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public HttpRequestWithBody options(String ... url) {
        return new HttpRequestWithBody(new ClientRequest(HttpMethod.OPTIONS, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public HttpRequestWithBody post(String ... url) {
        return new HttpRequestWithBody(new ClientRequest(HttpMethod.POST, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public HttpRequestWithBody delete(String ... url) {
        return new HttpRequestWithBody(new ClientRequest(HttpMethod.DELETE, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public HttpRequestWithBody patch(String ... url) {
        return new HttpRequestWithBody(new ClientRequest(HttpMethod.PATCH, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public HttpRequestWithBody put(String ... url) {
        return new HttpRequestWithBody(new ClientRequest(HttpMethod.PUT, this.resolveUrl(url), this.syncClient, this.asyncClient, this.defaultHeaders));
    }

    public CookieStore cookieStore() {
        return this.cookieStore;
    }

    public ClientStats stats() {
        return new ClientStats(this.syncConnectionManager.getTotalStats(), this.asyncConnectionManager.getTotalStats());
    }

    String resolveUrl(String ... paths) {
        StringJoiner pathJoiner = new StringJoiner("/");
        for (String path : paths) {
            if (path == null || path.trim().isEmpty()) continue;
            path = path.startsWith("/") ? path.substring(1) : path;
            path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            pathJoiner.add(path);
        }
        if (this.baseUrl == null || this.baseUrl.trim().isEmpty()) {
            return pathJoiner.toString();
        }
        String base = this.urlTransformer.apply(this.baseUrl);
        base = !base.endsWith("/") ? base + "/" : base;
        return base + pathJoiner.toString();
    }

    void closeIdleConnections() {
        if (this.asyncConnectionManager != null) {
            this.asyncConnectionManager.closeExpiredConnections();
            this.asyncConnectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
        }
        if (this.syncConnectionManager != null) {
            this.syncConnectionManager.closeExpiredConnections();
            this.syncConnectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void close() {
        try {
            if (this.syncClient != null) {
                this.syncClient.close();
                this.syncConnectionManager.close();
            }
            if (this.asyncClient != null && this.asyncClient.isRunning()) {
                this.asyncClient.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        ClientContainer.removeClient(this);
    }

    private String newUUID() {
        return UUID.randomUUID().toString().substring(0, 8);
    }
}

