/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.restclient.http.mapper;

import io.joshworks.restclient.http.MediaType;
import io.joshworks.restclient.http.mapper.JsonMapper;
import io.joshworks.restclient.http.mapper.ObjectMapper;
import io.joshworks.restclient.http.mapper.TextPlainMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ObjectMappers {
    private static final Map<MediaType, ObjectMapper> mappers = new HashMap<MediaType, ObjectMapper>();

    private ObjectMappers() {
    }

    public static void register(MediaType mediaType, ObjectMapper mapper) {
        Objects.requireNonNull(mediaType, "MediaType must be provided");
        Objects.requireNonNull(mapper, "ObjectMapper must provided");
        mappers.put(mediaType, mapper);
    }

    public static void clear() {
        mappers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectMapper getMapper(MediaType type) {
        ObjectMapper mapper;
        if (mappers.isEmpty()) {
            Map<MediaType, ObjectMapper> map = mappers;
            synchronized (map) {
                if (mappers.isEmpty()) {
                    ObjectMappers.register(MediaType.TEXT_PLAIN_TYPE, new TextPlainMapper());
                    ObjectMappers.register(MediaType.APPLICATION_JSON_TYPE, new JsonMapper());
                }
            }
        }
        if ((mapper = mappers.get(type)) == null) {
            mapper = mappers.entrySet().stream().filter(kv -> ((MediaType)kv.getKey()).isCompatible(type)).map(Map.Entry::getValue).findFirst().get();
        }
        return mapper;
    }
}

