/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import io.joynr.capabilities.StaticCapabilitiesProvisioning;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceContentProvider {
    private static final Logger logger = LoggerFactory.getLogger(ResourceContentProvider.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public String readFromFileOrResourceOrUrl(String provisionedCapabilitiesJsonFilename) {
        logger.trace("Attempting to read statically provisioned capabilities from JSON in file/resource/URL: {}", (Object)provisionedCapabilitiesJsonFilename);
        IOException ioException = null;
        String result = null;
        try {
            URI uri = new URI(provisionedCapabilitiesJsonFilename);
            if (!uri.isAbsolute()) {
                throw new URISyntaxException(provisionedCapabilitiesJsonFilename, "URI is not absolute");
            }
            result = this.readFromUri(uri);
        }
        catch (URISyntaxException e) {
            logger.trace("{} is not a URL. Trying to read from filesystem/classpath.", (Object)provisionedCapabilitiesJsonFilename, (Object)e);
        }
        catch (IOException e) {
            ioException = e;
        }
        if (result == null && ioException == null) {
            try {
                result = this.readFromFileOrClasspath(provisionedCapabilitiesJsonFilename);
            }
            catch (IOException e) {
                ioException = e;
            }
        }
        if (ioException != null) {
            throw new IllegalArgumentException("Unable to read provisioned capabilities from " + provisionedCapabilitiesJsonFilename, ioException);
        }
        if (result == null) {
            throw new IllegalStateException(provisionedCapabilitiesJsonFilename + " not found as URL or on filesystem or classpath.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromFileOrClasspath(String provisionedCapabilitiesJsonFilename) throws IOException {
        logger.trace("Attempting to read {} from file / classpath", (Object)provisionedCapabilitiesJsonFilename);
        Path filePath = Paths.get(provisionedCapabilitiesJsonFilename, new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            return new String(Files.readAllBytes(filePath), "UTF-8");
        }
        logger.trace("File {} doesn't exist on filesystem, attempting to read from classpath.", (Object)provisionedCapabilitiesJsonFilename);
        try (InputStream resourceAsStream = null;){
            resourceAsStream = StaticCapabilitiesProvisioning.class.getClassLoader().getResourceAsStream(provisionedCapabilitiesJsonFilename);
            if (resourceAsStream != null) {
                String string = this.readFromStream(resourceAsStream);
                return string;
            }
            String string = null;
            return string;
        }
    }

    private String readFromUri(URI uri) throws IOException {
        URL url = new URL(uri.toString());
        logger.trace("Attempting to read from URL {}", (Object)url);
        InputStream inputStream = url.openStream();
        return this.readFromStream(inputStream);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readFromStream(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, UTF8);){
            String string;
            try (BufferedReader bufferedReader = new BufferedReader(reader);){
                StringBuilder builder = new StringBuilder();
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    builder.append(line);
                }
                string = builder.toString();
            }
            return string;
        }
    }
}

