/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.capabilities.CapabilityUtils;
import io.joynr.capabilities.LegacyCapabilitiesProvisioning;
import io.joynr.capabilities.ResourceContentProvider;
import io.joynr.capabilities.StaticCapabilitiesProvisioning;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.routing.RoutingTable;
import io.joynr.util.ObjectMapper;
import joynr.types.GlobalDiscoveryEntry;
import joynr.types.ProviderScope;

public class StaticCapabilitiesProvisioningWithRoutingTableInsertion
extends StaticCapabilitiesProvisioning {
    @Inject
    public StaticCapabilitiesProvisioningWithRoutingTableInsertion(@Named(value="joynr.capabilities.provisioned.file") String provisionedCapabilitiesFile, @Named(value="joynr.messaging.channelid") String localChannelId, ObjectMapper objectMapper, RoutingTable routingTable, LegacyCapabilitiesProvisioning legacyCapabilitiesProvisioning, ResourceContentProvider resourceContentProvider, @Named(value="joynr.internal.messaging.gbidArray") String[] gbids) {
        super(provisionedCapabilitiesFile, localChannelId, objectMapper, legacyCapabilitiesProvisioning, resourceContentProvider, gbids);
        this.addAddressesToRoutingTable(routingTable);
    }

    private void addAddressesToRoutingTable(RoutingTable routingTable) {
        for (GlobalDiscoveryEntry globalDiscoveryEntry : this.discoveryEntries) {
            if ("infrastructure/GlobalCapabilitiesDirectory".equals(globalDiscoveryEntry.getInterfaceName())) {
                routingTable.setGcdParticipantId(globalDiscoveryEntry.getParticipantId());
            }
            boolean isGloballyVisible = globalDiscoveryEntry.getQos().getScope() == ProviderScope.GLOBAL;
            long expiryDateMs = Long.MAX_VALUE;
            boolean isSticky = true;
            if (routingTable.put(globalDiscoveryEntry.getParticipantId(), CapabilityUtils.getAddressFromGlobalDiscoveryEntry(globalDiscoveryEntry), isGloballyVisible, Long.MAX_VALUE, true)) continue;
            throw new JoynrRuntimeException("Unable to add routing entries for provisioned discovery entries.");
        }
    }
}

