/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.Inject;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.util.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import joynr.system.RoutingTypes.Address;
import joynr.types.DiscoveryEntry;
import joynr.types.DiscoveryEntryWithMetaInfo;
import joynr.types.GlobalDiscoveryEntry;
import joynr.types.ProviderQos;
import joynr.types.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityUtils {
    private static final Logger logger = LoggerFactory.getLogger(CapabilityUtils.class);
    @Inject
    private static ObjectMapper objectMapper;

    public static DiscoveryEntry globalDiscoveryEntry2DiscoveryEntry(GlobalDiscoveryEntry globalDiscoveryEntry) {
        return new DiscoveryEntry(globalDiscoveryEntry.getProviderVersion(), globalDiscoveryEntry.getDomain(), globalDiscoveryEntry.getInterfaceName(), globalDiscoveryEntry.getParticipantId(), globalDiscoveryEntry.getQos(), globalDiscoveryEntry.getLastSeenDateMs(), globalDiscoveryEntry.getExpiryDateMs(), globalDiscoveryEntry.getPublicKeyId());
    }

    public static GlobalDiscoveryEntry newGlobalDiscoveryEntry(Version providerVesion, String domain, String interfaceName, String participantId, ProviderQos qos, Long lastSeenDateMs, Long expiryDateMs, String publicKeyId, Address address) {
        return new GlobalDiscoveryEntry(providerVesion, domain, interfaceName, participantId, qos, lastSeenDateMs, expiryDateMs, publicKeyId, CapabilityUtils.serializeAddress(address));
    }

    public static GlobalDiscoveryEntry discoveryEntry2GlobalDiscoveryEntry(DiscoveryEntry discoveryEntry, Address globalAddress) {
        return new GlobalDiscoveryEntry(discoveryEntry.getProviderVersion(), discoveryEntry.getDomain(), discoveryEntry.getInterfaceName(), discoveryEntry.getParticipantId(), discoveryEntry.getQos(), discoveryEntry.getLastSeenDateMs(), discoveryEntry.getExpiryDateMs(), discoveryEntry.getPublicKeyId(), CapabilityUtils.serializeAddress(globalAddress));
    }

    public static Address getAddressFromGlobalDiscoveryEntry(GlobalDiscoveryEntry globalDiscoveryEntry) {
        Address result;
        if (globalDiscoveryEntry == null || globalDiscoveryEntry.getAddress() == null) {
            throw new IllegalArgumentException("Neither globalDiscoveryEntry nor its address can be null.");
        }
        logger.trace("Attempting to deserialize {} as an Address.", (Object)globalDiscoveryEntry.getAddress());
        try {
            result = (Address)objectMapper.readValue(globalDiscoveryEntry.getAddress(), Address.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Global discovery entry address value %s cannot be deserialized as an Address.", globalDiscoveryEntry.getAddress()), e);
        }
        return result;
    }

    public static String serializeAddress(Address globalAddress) {
        String serializedAddress;
        try {
            serializedAddress = objectMapper.writeValueAsString((Object)globalAddress);
        }
        catch (JsonProcessingException e) {
            throw new JoynrRuntimeException((Throwable)e);
        }
        return serializedAddress;
    }

    public static DiscoveryEntry convertToDiscoveryEntry(DiscoveryEntryWithMetaInfo entry) {
        return new DiscoveryEntry((DiscoveryEntry)entry);
    }

    public static List<DiscoveryEntry> convertToDiscoveryEntryList(Collection<DiscoveryEntryWithMetaInfo> entriesWithMetaInfo) {
        ArrayList<DiscoveryEntry> entries = new ArrayList<DiscoveryEntry>(entriesWithMetaInfo.size());
        for (DiscoveryEntryWithMetaInfo entry : entriesWithMetaInfo) {
            entries.add(CapabilityUtils.convertToDiscoveryEntry(entry));
        }
        return entries;
    }

    public static Set<DiscoveryEntry> convertToDiscoveryEntrySet(Collection<DiscoveryEntryWithMetaInfo> entriesWithMetaInfo) {
        HashSet<DiscoveryEntry> entries = new HashSet<DiscoveryEntry>(entriesWithMetaInfo.size());
        for (DiscoveryEntryWithMetaInfo entry : entriesWithMetaInfo) {
            entries.add(CapabilityUtils.convertToDiscoveryEntry(entry));
        }
        return entries;
    }

    public static DiscoveryEntryWithMetaInfo convertToDiscoveryEntryWithMetaInfo(boolean isLocal, DiscoveryEntry entry) {
        return new DiscoveryEntryWithMetaInfo(entry.getProviderVersion(), entry.getDomain(), entry.getInterfaceName(), entry.getParticipantId(), entry.getQos(), entry.getLastSeenDateMs(), entry.getExpiryDateMs(), entry.getPublicKeyId(), Boolean.valueOf(isLocal));
    }

    public static List<DiscoveryEntryWithMetaInfo> convertToDiscoveryEntryWithMetaInfoList(boolean isLocal, Collection<? extends DiscoveryEntry> entries) {
        ArrayList<DiscoveryEntryWithMetaInfo> entriesWithMetaInfo = new ArrayList<DiscoveryEntryWithMetaInfo>(entries.size());
        for (DiscoveryEntry discoveryEntry : entries) {
            entriesWithMetaInfo.add(CapabilityUtils.convertToDiscoveryEntryWithMetaInfo(isLocal, discoveryEntry));
        }
        return entriesWithMetaInfo;
    }

    public static Set<DiscoveryEntryWithMetaInfo> convertToDiscoveryEntryWithMetaInfoSet(boolean isLocal, Collection<? extends DiscoveryEntry> entries) {
        HashSet<DiscoveryEntryWithMetaInfo> entriesWithMetaInfo = new HashSet<DiscoveryEntryWithMetaInfo>(entries.size());
        for (DiscoveryEntry discoveryEntry : entries) {
            entriesWithMetaInfo.add(CapabilityUtils.convertToDiscoveryEntryWithMetaInfo(isLocal, discoveryEntry));
        }
        return entriesWithMetaInfo;
    }
}

