/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.name.Names;
import io.joynr.guice.LowerCaseProperties;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyLoadingModule
extends AbstractModule {
    Logger logger = LoggerFactory.getLogger(PropertyLoadingModule.class);
    protected final Properties properties = new LowerCaseProperties();

    public PropertyLoadingModule(Properties ... allProperties) {
        this.mergeProperties(allProperties);
    }

    protected void mergeProperties(Properties ... allProperties) {
        for (Properties specialProperties : allProperties) {
            if (specialProperties == null) continue;
            this.properties.putAll((Map<?, ?>)specialProperties);
        }
    }

    protected String getProperty(String key, String defaultValue, Properties ... allProperties) {
        String value = defaultValue;
        for (Properties aProperties : allProperties) {
            value = aProperties.getProperty(key, value);
        }
        return value;
    }

    protected void logProperties() {
        Properties filteredProperties = this.getFilteredProperties("joynr.");
        filteredProperties.putAll((Map<?, ?>)this.getFilteredProperties("javax.net.ssl"));
        if (this.logger.isInfoEnabled()) {
            String formattedPropertiesOutput = filteredProperties.toString().replaceAll(",", "\n");
            this.logger.info("Properties loaded:\n{}", (Object)formattedPropertiesOutput);
        }
    }

    protected Properties getFilteredProperties(String prefix) {
        Set<Map.Entry<Object, Object>> entrySet = this.properties.entrySet();
        Properties filteredProperties = new Properties();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (!entry.getKey().toString().startsWith(prefix)) continue;
            filteredProperties.put(entry.getKey(), entry.getValue());
        }
        return filteredProperties;
    }

    protected void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.properties);
        this.logProperties();
    }
}

