/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.guice;

import com.google.inject.name.Names;
import io.joynr.guice.IApplication;
import io.joynr.guice.PropertyLoadingModule;
import java.lang.annotation.Annotation;
import java.util.Properties;

public class ApplicationModule
extends PropertyLoadingModule {
    private String fAppId = null;
    protected Class<? extends IApplication> fApplicationClass;

    public ApplicationModule(Class<? extends IApplication> applicationClass) {
        this(applicationClass.getName(), applicationClass);
    }

    public ApplicationModule(String appId, Class<? extends IApplication> applicationClass) {
        this(appId, applicationClass, new Properties());
    }

    public ApplicationModule(String appId, Class<? extends IApplication> applicationClass, Properties properties) {
        super(properties == null ? new Properties() : properties);
        this.fAppId = appId;
        this.fApplicationClass = applicationClass;
    }

    @Override
    protected void configure() {
        super.configure();
        this.bindApplication();
    }

    protected void bindApplication() {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"application.id")).toInstance((Object)this.fAppId);
        this.bind(IApplication.class).to(this.fApplicationClass);
    }

    protected String getAppId() {
        return this.fAppId;
    }
}

