/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.joynr.guice.ApplicationModule;
import io.joynr.guice.IApplication;

public class InjectorFactory<T extends ApplicationModule, S extends IApplication> {
    private Injector fInjector;
    private Module[] modules;
    private Injector rootInjector;

    public InjectorFactory(Module ... modules) {
        this.modules = modules;
    }

    public void updateModules(Module ... upateModules) {
        if (this.fInjector != null) {
            throw new RuntimeException("updateModules shall be invoked BEFORE the factory gets used for the first time!");
        }
        this.modules = upateModules;
    }

    protected Module[] getModules() {
        return this.modules;
    }

    public S createApplication(T applicationModule, Module ... applicationSpecificModules) {
        Module[] modules = new Module[applicationSpecificModules != null ? applicationSpecificModules.length + 1 : 1];
        modules[0] = applicationModule;
        if (applicationSpecificModules != null) {
            for (int i = 0; i < applicationSpecificModules.length; ++i) {
                modules[i + 1] = applicationSpecificModules[i];
            }
        }
        return (S)((IApplication)this.createChildInjector(modules).getInstance(IApplication.class));
    }

    public S createApplication() {
        return (S)((IApplication)this.createChildInjector(new Module[0]).getInstance(IApplication.class));
    }

    protected void setRootInjector(Injector rootInjector) {
        if (this.fInjector != null) {
            throw new RuntimeException("setRootInjector shall be invoked BEFORE the factory gets used for the first time!");
        }
        this.rootInjector = rootInjector;
    }

    public Injector getInjector() {
        if (this.fInjector == null) {
            this.fInjector = this.rootInjector == null ? Guice.createInjector((Module[])this.modules) : this.rootInjector.createChildInjector(this.modules);
        }
        return this.fInjector;
    }

    public Injector createChildInjector(Module ... withModules) {
        return this.getInjector().createChildInjector(withModules);
    }
}

