/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import java.util.Arrays;
import java.util.List;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;

public class AceValidator {
    private MasterAccessControlEntry masterAce;
    private MasterAccessControlEntry mediatorAce;
    private OwnerAccessControlEntry ownerAce;

    public AceValidator(MasterAccessControlEntry masterAce, MasterAccessControlEntry mediatorAce, OwnerAccessControlEntry ownerAce) {
        this.masterAce = masterAce;
        this.mediatorAce = mediatorAce;
        this.ownerAce = ownerAce;
    }

    public boolean isValid() {
        return this.isOwnerValid();
    }

    public boolean isOwnerValid() {
        boolean isOwnerValid = true;
        if (this.mediatorAce != null) {
            isOwnerValid = this.isMediatorValid() && this.validateOwner(this.mediatorAce);
        } else if (this.masterAce != null) {
            isOwnerValid = this.validateOwner(this.masterAce);
        }
        return isOwnerValid;
    }

    private boolean validateOwner(MasterAccessControlEntry targetMasterAce) {
        if (this.ownerAce == null) {
            return true;
        }
        boolean isValid = true;
        List<Permission> masterAcePossibleConsumerPermissions = Arrays.asList(targetMasterAce.getPossibleConsumerPermissions());
        List<TrustLevel> masterAcePossibleRequiredTrustLevels = Arrays.asList(targetMasterAce.getPossibleRequiredTrustLevels());
        if (!masterAcePossibleConsumerPermissions.contains(this.ownerAce.getConsumerPermission())) {
            isValid = false;
        } else if (!masterAcePossibleRequiredTrustLevels.contains(this.ownerAce.getRequiredTrustLevel())) {
            isValid = false;
        }
        return isValid;
    }

    public boolean isMediatorValid() {
        if (this.mediatorAce == null) {
            return true;
        }
        if (this.masterAce == null) {
            return true;
        }
        boolean isMediatorValid = true;
        List<Permission> masterAcePossibleConsumerPermissions = Arrays.asList(this.masterAce.getPossibleConsumerPermissions());
        List<Permission> mediatorAcePossibleConsumerPermissions = Arrays.asList(this.mediatorAce.getPossibleConsumerPermissions());
        List<TrustLevel> masterAcePossibleRequiredTrustLevels = Arrays.asList(this.masterAce.getPossibleRequiredTrustLevels());
        List<TrustLevel> mediatorAcePossibleRequiredTrustLevels = Arrays.asList(this.mediatorAce.getPossibleRequiredTrustLevels());
        if (!masterAcePossibleConsumerPermissions.contains(this.mediatorAce.getDefaultConsumerPermission())) {
            isMediatorValid = false;
        } else if (!masterAcePossibleConsumerPermissions.containsAll(mediatorAcePossibleConsumerPermissions)) {
            isMediatorValid = false;
        } else if (!masterAcePossibleRequiredTrustLevels.contains(this.mediatorAce.getDefaultRequiredTrustLevel())) {
            isMediatorValid = false;
        } else if (!masterAcePossibleRequiredTrustLevels.containsAll(mediatorAcePossibleRequiredTrustLevels)) {
            isMediatorValid = false;
        }
        return isMediatorValid;
    }
}

