/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import com.google.inject.Inject;
import io.joynr.accesscontrol.AceValidator;
import io.joynr.accesscontrol.DefaultDomainAccessControlProvisioning;
import io.joynr.accesscontrol.DomainAccessControlProvisioning;
import io.joynr.accesscontrol.DomainAccessControlStore;
import io.joynr.accesscontrol.DomainRoleEntryStore;
import io.joynr.accesscontrol.MasterAccessControlEntryStore;
import io.joynr.accesscontrol.MasterRegistrationControlEntryStore;
import io.joynr.accesscontrol.OwnerAccessControlEntryStore;
import io.joynr.accesscontrol.OwnerRegistrationControlEntryStore;
import io.joynr.accesscontrol.RceValidator;
import java.util.List;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.MasterRegistrationControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerRegistrationControlEntry;
import joynr.infrastructure.DacTypes.Role;

public class DomainAccessControlStoreCqEngine
implements DomainAccessControlStore {
    private static final String WILDCARD = "*";
    private DomainRoleEntryStore domainRoleEntryStore;
    private MasterAccessControlEntryStore masterAccessControlEntryStore;
    private MasterAccessControlEntryStore mediatorAccessControlEntryStore;
    private OwnerAccessControlEntryStore ownerAccessControlEntryStore;
    private MasterRegistrationControlEntryStore masterRegistrationControlEntryStore;
    private MasterRegistrationControlEntryStore mediatorRegistrationControlEntryStore;
    private OwnerRegistrationControlEntryStore ownerRegistrationControlEntryStore;

    @Inject
    public DomainAccessControlStoreCqEngine(DomainAccessControlProvisioning domainAccessControlProvisioning) {
        this.domainRoleEntryStore = new DomainRoleEntryStore(domainAccessControlProvisioning);
        this.masterRegistrationControlEntryStore = new MasterRegistrationControlEntryStore(this.domainRoleEntryStore);
        this.mediatorRegistrationControlEntryStore = new MasterRegistrationControlEntryStore(this.domainRoleEntryStore);
        this.ownerRegistrationControlEntryStore = new OwnerRegistrationControlEntryStore(this.domainRoleEntryStore);
        this.masterAccessControlEntryStore = new MasterAccessControlEntryStore(domainAccessControlProvisioning, this.domainRoleEntryStore);
        this.mediatorAccessControlEntryStore = new MasterAccessControlEntryStore((DomainAccessControlProvisioning)new DefaultDomainAccessControlProvisioning(), this.domainRoleEntryStore);
        this.ownerAccessControlEntryStore = new OwnerAccessControlEntryStore(this.domainRoleEntryStore);
    }

    @Override
    public synchronized List<DomainRoleEntry> getDomainRoles(String uid) {
        return this.domainRoleEntryStore.getDomainRoles(uid);
    }

    @Override
    public synchronized DomainRoleEntry getDomainRole(String uid, Role role) {
        return this.domainRoleEntryStore.getDomainRole(uid, role);
    }

    @Override
    public synchronized Boolean updateDomainRole(DomainRoleEntry updatedEntry) {
        return this.domainRoleEntryStore.updateDomainRole(updatedEntry);
    }

    @Override
    public synchronized Boolean removeDomainRole(String uid, Role role) {
        return this.domainRoleEntryStore.removeDomainRole(uid, role);
    }

    @Override
    public synchronized List<MasterAccessControlEntry> getMasterAccessControlEntries(String uid) {
        return this.masterAccessControlEntryStore.getControlEntries(uid);
    }

    @Override
    public synchronized List<MasterAccessControlEntry> getEditableMasterAccessControlEntries(String uid) {
        return this.masterAccessControlEntryStore.getEditableAces(uid, Role.MASTER);
    }

    @Override
    public synchronized List<MasterAccessControlEntry> getMasterAccessControlEntries(String domain, String interfaceName) {
        return this.masterAccessControlEntryStore.getControlEntries(domain, interfaceName);
    }

    @Override
    public synchronized List<MasterAccessControlEntry> getMasterAccessControlEntries(String uid, String domain, String interfaceName) {
        return this.masterAccessControlEntryStore.getControlEntries(uid, domain, interfaceName);
    }

    @Override
    public synchronized MasterAccessControlEntry getMasterAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        return this.masterAccessControlEntryStore.getControlEntry(uid, domain, interfaceName, operation);
    }

    @Override
    public synchronized Boolean updateMasterAccessControlEntry(MasterAccessControlEntry updatedMasterAce) {
        return this.masterAccessControlEntryStore.updateControlEntry(updatedMasterAce);
    }

    @Override
    public synchronized Boolean removeMasterAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        return this.masterAccessControlEntryStore.removeControlEntry(uid, domain, interfaceName, operation);
    }

    @Override
    public synchronized List<MasterAccessControlEntry> getMediatorAccessControlEntries(String uid) {
        return this.mediatorAccessControlEntryStore.getControlEntries(uid);
    }

    @Override
    public synchronized List<MasterAccessControlEntry> getEditableMediatorAccessControlEntries(String uid) {
        return this.mediatorAccessControlEntryStore.getEditableAces(uid, Role.MASTER);
    }

    @Override
    public synchronized List<MasterAccessControlEntry> getMediatorAccessControlEntries(String domain, String interfaceName) {
        return this.mediatorAccessControlEntryStore.getControlEntries(domain, interfaceName);
    }

    @Override
    public synchronized List<MasterAccessControlEntry> getMediatorAccessControlEntries(String uid, String domain, String interfaceName) {
        return this.mediatorAccessControlEntryStore.getControlEntries(uid, domain, interfaceName);
    }

    @Override
    public synchronized MasterAccessControlEntry getMediatorAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        MasterAccessControlEntry mediatorAce = this.mediatorAccessControlEntryStore.getControlEntry(uid, domain, interfaceName, operation);
        if (mediatorAce == null) {
            mediatorAce = this.mediatorAccessControlEntryStore.getControlEntry(uid, domain, interfaceName, WILDCARD);
        }
        return mediatorAce;
    }

    @Override
    public synchronized Boolean updateMediatorAccessControlEntry(MasterAccessControlEntry updatedMediatorAce) {
        boolean updateSuccess = false;
        MasterAccessControlEntry masterAce = this.getMasterAccessControlEntry(updatedMediatorAce.getUid(), updatedMediatorAce.getDomain(), updatedMediatorAce.getInterfaceName(), updatedMediatorAce.getOperation());
        AceValidator aceValidator = new AceValidator(masterAce, updatedMediatorAce, null);
        if (aceValidator.isMediatorValid()) {
            updateSuccess = this.mediatorAccessControlEntryStore.updateControlEntry(updatedMediatorAce);
        }
        return updateSuccess;
    }

    @Override
    public synchronized Boolean removeMediatorAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        return this.mediatorAccessControlEntryStore.removeControlEntry(uid, domain, interfaceName, operation);
    }

    @Override
    public synchronized List<OwnerAccessControlEntry> getOwnerAccessControlEntries(String uid) {
        return this.ownerAccessControlEntryStore.getControlEntries(uid);
    }

    @Override
    public synchronized List<OwnerAccessControlEntry> getEditableOwnerAccessControlEntries(String uid) {
        return this.ownerAccessControlEntryStore.getEditableAces(uid, Role.OWNER);
    }

    @Override
    public synchronized List<OwnerAccessControlEntry> getOwnerAccessControlEntries(String domain, String interfaceName) {
        return this.ownerAccessControlEntryStore.getControlEntries(domain, interfaceName);
    }

    @Override
    public synchronized List<OwnerAccessControlEntry> getOwnerAccessControlEntries(String uid, String domain, String interfaceName) {
        return this.ownerAccessControlEntryStore.getControlEntries(uid, domain, interfaceName);
    }

    @Override
    public synchronized OwnerAccessControlEntry getOwnerAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        OwnerAccessControlEntry ownerAce = this.ownerAccessControlEntryStore.getControlEntry(uid, domain, interfaceName, operation);
        if (ownerAce == null) {
            ownerAce = this.ownerAccessControlEntryStore.getControlEntry(uid, domain, interfaceName, WILDCARD);
        }
        return ownerAce;
    }

    @Override
    public synchronized Boolean updateOwnerAccessControlEntry(OwnerAccessControlEntry updatedOwnerAce) {
        MasterAccessControlEntry mediatorAce;
        boolean updateSuccess = false;
        MasterAccessControlEntry masterAce = this.getMasterAccessControlEntry(updatedOwnerAce.getUid(), updatedOwnerAce.getDomain(), updatedOwnerAce.getInterfaceName(), updatedOwnerAce.getOperation());
        AceValidator aceValidator = new AceValidator(masterAce, mediatorAce = this.getMediatorAccessControlEntry(updatedOwnerAce.getUid(), updatedOwnerAce.getDomain(), updatedOwnerAce.getInterfaceName(), updatedOwnerAce.getOperation()), updatedOwnerAce);
        if (aceValidator.isOwnerValid()) {
            updateSuccess = this.ownerAccessControlEntryStore.updateControlEntry(updatedOwnerAce);
        }
        return updateSuccess;
    }

    @Override
    public synchronized Boolean removeOwnerAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        return this.ownerAccessControlEntryStore.removeControlEntry(uid, domain, interfaceName, operation);
    }

    @Override
    public synchronized List<MasterRegistrationControlEntry> getMasterRegistrationControlEntries(String uid) {
        return this.masterRegistrationControlEntryStore.getControlEntries(uid);
    }

    @Override
    public synchronized List<MasterRegistrationControlEntry> getEditableMasterRegistrationControlEntries(String uid) {
        return this.masterRegistrationControlEntryStore.getEditableAces(uid, Role.MASTER);
    }

    @Override
    public synchronized List<MasterRegistrationControlEntry> getMasterRegistrationControlEntries(String domain, String interfaceName) {
        return this.masterRegistrationControlEntryStore.getControlEntries(domain, interfaceName);
    }

    @Override
    public synchronized MasterRegistrationControlEntry getMasterRegistrationControlEntry(String uid, String domain, String interfaceName) {
        return this.masterRegistrationControlEntryStore.getControlEntry(uid, domain, interfaceName);
    }

    @Override
    public synchronized Boolean updateMasterRegistrationControlEntry(MasterRegistrationControlEntry updatedMasterRce) {
        return this.masterRegistrationControlEntryStore.updateControlEntry(updatedMasterRce);
    }

    @Override
    public synchronized Boolean removeMasterRegistrationControlEntry(String uid, String domain, String interfaceName) {
        return this.masterRegistrationControlEntryStore.removeControlEntry(uid, domain, interfaceName);
    }

    @Override
    public synchronized List<MasterRegistrationControlEntry> getMediatorRegistrationControlEntries(String uid) {
        return this.mediatorRegistrationControlEntryStore.getControlEntries(uid);
    }

    @Override
    public synchronized List<MasterRegistrationControlEntry> getEditableMediatorRegistrationControlEntries(String uid) {
        return this.mediatorRegistrationControlEntryStore.getEditableAces(uid, Role.MASTER);
    }

    @Override
    public synchronized List<MasterRegistrationControlEntry> getMediatorRegistrationControlEntries(String domain, String interfaceName) {
        return this.mediatorRegistrationControlEntryStore.getControlEntries(domain, interfaceName);
    }

    @Override
    public synchronized MasterRegistrationControlEntry getMediatorRegistrationControlEntry(String uid, String domain, String interfaceName) {
        return this.mediatorRegistrationControlEntryStore.getControlEntry(uid, domain, interfaceName);
    }

    @Override
    public synchronized Boolean updateMediatorRegistrationControlEntry(MasterRegistrationControlEntry updatedMediatorRce) {
        boolean updateSuccess = false;
        MasterRegistrationControlEntry masterRce = this.getMasterRegistrationControlEntry(updatedMediatorRce.getUid(), updatedMediatorRce.getDomain(), updatedMediatorRce.getInterfaceName());
        RceValidator rceValidator = new RceValidator(masterRce, updatedMediatorRce, null);
        if (rceValidator.isMediatorValid()) {
            updateSuccess = this.mediatorRegistrationControlEntryStore.updateControlEntry(updatedMediatorRce);
        }
        return updateSuccess;
    }

    @Override
    public synchronized Boolean removeMediatorRegistrationControlEntry(String uid, String domain, String interfaceName) {
        return this.mediatorRegistrationControlEntryStore.removeControlEntry(uid, domain, interfaceName);
    }

    @Override
    public synchronized List<OwnerRegistrationControlEntry> getOwnerRegistrationControlEntries(String uid) {
        return this.ownerRegistrationControlEntryStore.getControlEntries(uid);
    }

    @Override
    public synchronized List<OwnerRegistrationControlEntry> getEditableOwnerRegistrationControlEntries(String uid) {
        return this.ownerRegistrationControlEntryStore.getEditableAces(uid, Role.OWNER);
    }

    @Override
    public synchronized List<OwnerRegistrationControlEntry> getOwnerRegistrationControlEntries(String domain, String interfaceName) {
        return this.ownerRegistrationControlEntryStore.getControlEntries(domain, interfaceName);
    }

    @Override
    public synchronized OwnerRegistrationControlEntry getOwnerRegistrationControlEntry(String uid, String domain, String interfaceName) {
        return this.ownerRegistrationControlEntryStore.getControlEntry(uid, domain, interfaceName);
    }

    @Override
    public synchronized Boolean updateOwnerRegistrationControlEntry(OwnerRegistrationControlEntry updatedOwnerRce) {
        MasterRegistrationControlEntry mediatorRce;
        boolean updateSuccess = false;
        MasterRegistrationControlEntry masterRce = this.getMasterRegistrationControlEntry(updatedOwnerRce.getUid(), updatedOwnerRce.getDomain(), updatedOwnerRce.getInterfaceName());
        RceValidator rceValidator = new RceValidator(masterRce, mediatorRce = this.getMediatorRegistrationControlEntry(updatedOwnerRce.getUid(), updatedOwnerRce.getDomain(), updatedOwnerRce.getInterfaceName()), updatedOwnerRce);
        if (rceValidator.isOwnerValid()) {
            updateSuccess = this.ownerRegistrationControlEntryStore.updateControlEntry(updatedOwnerRce);
        }
        return updateSuccess;
    }

    @Override
    public synchronized Boolean removeOwnerRegistrationControlEntry(String uid, String domain, String interfaceName) {
        return this.ownerRegistrationControlEntryStore.removeControlEntry(uid, domain, interfaceName);
    }
}

