/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.resultset.ResultSet;
import io.joynr.accesscontrol.DomainAccessControlProvisioning;
import io.joynr.accesscontrol.DomainRoleEntryDB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainRoleEntryStore {
    private static final Logger logger = LoggerFactory.getLogger(DomainRoleEntryStore.class);
    private IndexedCollection<DomainRoleEntryDB> domainRoleDB = new ConcurrentIndexedCollection();

    public DomainRoleEntryStore(DomainAccessControlProvisioning domainAccessControlProvisioning) {
        this.domainRoleDB.addIndex((Index)HashIndex.onAttribute(DomainRoleEntryDB.ROLE));
        this.domainRoleDB.addIndex((Index)HashIndex.onAttribute(DomainRoleEntryDB.UID));
        Collection domainRoleEntries = domainAccessControlProvisioning.getDomainRoleEntries();
        for (DomainRoleEntry provisionedDomainRoleEntry : domainRoleEntries) {
            this.updateDomainRole(provisionedDomainRoleEntry);
        }
    }

    public synchronized List<DomainRoleEntry> getDomainRoles(String uid) {
        ArrayList<DomainRoleEntry> domainRoles = new ArrayList<DomainRoleEntry>();
        Equal cqQuery = QueryFactory.equal(DomainRoleEntryDB.UID, (Object)uid);
        this.domainRoleDB.retrieve((Query)cqQuery).forEach(result -> domainRoles.add(result.getDomainRoleEntry()));
        return domainRoles;
    }

    public synchronized DomainRoleEntry getDomainRole(String uid, Role role) {
        DomainRoleEntry domainRole = null;
        And cqQuery = QueryFactory.and((Query)QueryFactory.equal(DomainRoleEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(DomainRoleEntryDB.ROLE, (Object)role.toString()));
        ResultSet cqResult = this.domainRoleDB.retrieve((Query)cqQuery);
        if (!cqResult.isEmpty()) {
            domainRole = ((DomainRoleEntryDB)((Object)cqResult.uniqueResult())).getDomainRoleEntry();
        }
        return domainRole;
    }

    public synchronized Boolean updateDomainRole(DomainRoleEntry updatedEntry) {
        boolean updateSuccess = false;
        try {
            this.domainRoleDB.add((Object)new DomainRoleEntryDB(updatedEntry));
            updateSuccess = true;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            logger.error("UpdateDomainRole failed.", (Throwable)e);
        }
        return updateSuccess;
    }

    public synchronized Boolean removeDomainRole(String uid, Role role) {
        And cqQuery = QueryFactory.and((Query)QueryFactory.equal(DomainRoleEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(DomainRoleEntryDB.ROLE, (Object)role.toString()));
        return this.domainRoleDB.update((Iterable)this.domainRoleDB.retrieve((Query)cqQuery), new ArrayList());
    }
}

