/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.option.AttributeOrder;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.resultset.ResultSet;
import io.joynr.accesscontrol.DomainRoleEntryStore;
import io.joynr.accesscontrol.datatype.MasterRegistrationControlEntryDB;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.MasterRegistrationControlEntry;
import joynr.infrastructure.DacTypes.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterRegistrationControlEntryStore {
    private static final String WILDCARD = "*";
    private static final String WILDCARD_REGEX = "\\*";
    private static final Logger logger = LoggerFactory.getLogger(MasterRegistrationControlEntryStore.class);
    private DomainRoleEntryStore domainRoleEntryStore;
    private IndexedCollection<MasterRegistrationControlEntryDB> masterRclDB = new ConcurrentIndexedCollection();

    public MasterRegistrationControlEntryStore(DomainRoleEntryStore domainRoleEntryStore) {
        this.domainRoleEntryStore = domainRoleEntryStore;
        this.masterRclDB.addIndex((Index)HashIndex.onAttribute(MasterRegistrationControlEntryDB.UID));
        this.masterRclDB.addIndex((Index)HashIndex.onAttribute(MasterRegistrationControlEntryDB.INTERFACENAME));
        this.masterRclDB.addIndex((Index)HashIndex.onAttribute(MasterRegistrationControlEntryDB.DOMAIN));
    }

    public List<MasterRegistrationControlEntry> getControlEntries(String uid) {
        ArrayList<MasterRegistrationControlEntry> controlEntries = new ArrayList<MasterRegistrationControlEntry>();
        Equal cqQuery = QueryFactory.equal(MasterRegistrationControlEntryDB.UID, (Object)uid);
        this.masterRclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getMasterRegistrationControlEntry()));
        if (controlEntries.isEmpty()) {
            Equal cqQueryWildcard = QueryFactory.equal(MasterRegistrationControlEntryDB.UID, (Object)WILDCARD);
            this.masterRclDB.retrieve((Query)cqQueryWildcard).forEach(result -> controlEntries.add(result.getMasterRegistrationControlEntry()));
        }
        return controlEntries;
    }

    public List<MasterRegistrationControlEntry> getEditableAces(String uid, Role role) {
        ArrayList<MasterRegistrationControlEntry> controlEntries = new ArrayList<MasterRegistrationControlEntry>();
        DomainRoleEntry domainRoleEntry = this.domainRoleEntryStore.getDomainRole(uid, role);
        if (domainRoleEntry == null) {
            return controlEntries;
        }
        if (domainRoleEntry.getDomains().length == 0) {
            return controlEntries;
        }
        for (String domain : domainRoleEntry.getDomains()) {
            And cqQuery = QueryFactory.and((Query)QueryFactory.equal(MasterRegistrationControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.DOMAIN, (Object)domain));
            this.masterRclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getMasterRegistrationControlEntry()));
        }
        return controlEntries;
    }

    public List<MasterRegistrationControlEntry> getControlEntries(String domain, String interfaceName) {
        ArrayList<MasterRegistrationControlEntry> controlEntries = new ArrayList<MasterRegistrationControlEntry>();
        And cqQuery = QueryFactory.and((Query)QueryFactory.equal(MasterRegistrationControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.INTERFACENAME, (Object)interfaceName));
        this.masterRclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getMasterRegistrationControlEntry()));
        return controlEntries;
    }

    public MasterRegistrationControlEntry getControlEntry(String uid, String domain, String interfaceName) {
        MasterRegistrationControlEntry masterRce = null;
        And cqQuery = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(MasterRegistrationControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.INTERFACENAME, (Object)interfaceName));
        ResultSet cqResult = this.masterRclDB.retrieve((Query)cqQuery, QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.descending(MasterRegistrationControlEntryDB.UID))));
        if (!cqResult.isEmpty()) {
            masterRce = ((MasterRegistrationControlEntryDB)((Object)cqResult.uniqueResult())).getMasterRegistrationControlEntry();
            return masterRce;
        }
        And cqQueryWithWildcard = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(MasterRegistrationControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.WILDCARDDOMAIN, (Object)true), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.INTERFACENAME, (Object)interfaceName));
        ResultSet cqResultWithWildcard = this.masterRclDB.retrieve((Query)cqQueryWithWildcard, QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.descending(MasterRegistrationControlEntryDB.UID))));
        if (!cqResultWithWildcard.isEmpty()) {
            List matchingEntries = cqResultWithWildcard.stream().filter(entry -> entry.getDomain().equals(WILDCARD) || domain.startsWith(entry.getDomain().split(WILDCARD_REGEX)[0])).collect(Collectors.toList());
            if (!matchingEntries.isEmpty()) {
                masterRce = ((MasterRegistrationControlEntryDB)((Object)matchingEntries.get(0))).getMasterRegistrationControlEntry();
            }
            return masterRce;
        }
        return null;
    }

    public Boolean updateControlEntry(MasterRegistrationControlEntry updatedMasterAce) {
        And cqQuery = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(MasterRegistrationControlEntryDB.UID, (Object)updatedMasterAce.getUid()), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.DOMAIN, (Object)updatedMasterAce.getDomain()), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.INTERFACENAME, (Object)updatedMasterAce.getInterfaceName()));
        ResultSet cqResult = this.masterRclDB.retrieve((Query)cqQuery, QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.descending(MasterRegistrationControlEntryDB.UID))));
        if (!cqResult.isEmpty()) {
            this.masterRclDB.remove(cqResult.uniqueResult());
        }
        return this.masterRclDB.add((Object)new MasterRegistrationControlEntryDB(updatedMasterAce));
    }

    public boolean removeControlEntry(String uid, String domain, String interfaceName) {
        boolean removeResult = false;
        try {
            And cqQuery = QueryFactory.and((Query)QueryFactory.equal(MasterRegistrationControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(MasterRegistrationControlEntryDB.INTERFACENAME, (Object)interfaceName));
            removeResult = this.masterRclDB.update((Iterable)this.masterRclDB.retrieve((Query)cqQuery), new ArrayList());
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            logger.error("Remove masterAcl failed.", (Throwable)e);
        }
        return removeResult;
    }
}

