/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.option.AttributeOrder;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.resultset.ResultSet;
import io.joynr.accesscontrol.DomainRoleEntryStore;
import io.joynr.accesscontrol.datatype.OwnerAccessControlEntryDB;
import java.util.ArrayList;
import java.util.List;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwnerAccessControlEntryStore {
    private static final String WILDCARD = "*";
    private static final Logger logger = LoggerFactory.getLogger(OwnerAccessControlEntryStore.class);
    private DomainRoleEntryStore domainRoleEntryStore;
    private IndexedCollection<OwnerAccessControlEntryDB> ownerAclDB = new ConcurrentIndexedCollection();

    public OwnerAccessControlEntryStore(DomainRoleEntryStore domainRoleEntryStore) {
        this.domainRoleEntryStore = domainRoleEntryStore;
        this.ownerAclDB.addIndex((Index)HashIndex.onAttribute(OwnerAccessControlEntryDB.UID));
        this.ownerAclDB.addIndex((Index)HashIndex.onAttribute(OwnerAccessControlEntryDB.INTERFACENAME));
        this.ownerAclDB.addIndex((Index)HashIndex.onAttribute(OwnerAccessControlEntryDB.DOMAIN));
        this.ownerAclDB.addIndex((Index)HashIndex.onAttribute(OwnerAccessControlEntryDB.OPERATION));
    }

    public List<OwnerAccessControlEntry> getControlEntries(String uid) {
        ArrayList<OwnerAccessControlEntry> controlEntries = new ArrayList<OwnerAccessControlEntry>();
        Equal cqQuery = QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)uid);
        this.ownerAclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getOwnerAccessControlEntry()));
        if (controlEntries.isEmpty()) {
            Equal cqQueryWildcard = QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)WILDCARD);
            this.ownerAclDB.retrieve((Query)cqQueryWildcard).forEach(result -> controlEntries.add(result.getOwnerAccessControlEntry()));
        }
        return controlEntries;
    }

    public List<OwnerAccessControlEntry> getEditableAces(String uid, Role role) {
        ArrayList<OwnerAccessControlEntry> controlEntries = new ArrayList<OwnerAccessControlEntry>();
        DomainRoleEntry domainRoleEntry = this.domainRoleEntryStore.getDomainRole(uid, role);
        if (domainRoleEntry == null) {
            return controlEntries;
        }
        if (domainRoleEntry.getDomains().length == 0) {
            return controlEntries;
        }
        for (String domain : domainRoleEntry.getDomains()) {
            And cqQuery = QueryFactory.and((Query)QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.DOMAIN, (Object)domain));
            this.ownerAclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getOwnerAccessControlEntry()));
        }
        return controlEntries;
    }

    public List<OwnerAccessControlEntry> getControlEntries(String domain, String interfaceName) {
        ArrayList<OwnerAccessControlEntry> controlEntries = new ArrayList<OwnerAccessControlEntry>();
        And cqQuery = QueryFactory.and((Query)QueryFactory.equal(OwnerAccessControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.INTERFACENAME, (Object)interfaceName));
        this.ownerAclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getOwnerAccessControlEntry()));
        return controlEntries;
    }

    public List<OwnerAccessControlEntry> getControlEntries(String uid, String domain, String interfaceName) {
        ArrayList<OwnerAccessControlEntry> controlEntries = new ArrayList<OwnerAccessControlEntry>();
        And cqQuery = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.INTERFACENAME, (Object)interfaceName));
        ResultSet cqResult = this.ownerAclDB.retrieve((Query)cqQuery, QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.descending(OwnerAccessControlEntryDB.UID))));
        String currentUid = null;
        for (OwnerAccessControlEntryDB result : cqResult) {
            if (currentUid == null) {
                currentUid = result.getUid();
            } else if (currentUid.equals(result.getUid())) break;
            controlEntries.add(result.getOwnerAccessControlEntry());
        }
        return controlEntries;
    }

    public OwnerAccessControlEntry getControlEntry(String uid, String domain, String interfaceName, String operation) {
        OwnerAccessControlEntry ownerAce = null;
        And cqQuery = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.INTERFACENAME, (Object)interfaceName), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.OPERATION, (Object)operation));
        ResultSet cqResult = this.ownerAclDB.retrieve((Query)cqQuery);
        if (!cqResult.isEmpty()) {
            ownerAce = ((OwnerAccessControlEntryDB)((Object)cqResult.uniqueResult())).getOwnerAccessControlEntry();
        } else {
            And cqQueryWildcard = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.INTERFACENAME, (Object)interfaceName), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.OPERATION, (Object)WILDCARD));
            cqResult = this.ownerAclDB.retrieve((Query)cqQueryWildcard);
            if (!cqResult.isEmpty()) {
                ownerAce = ((OwnerAccessControlEntryDB)((Object)cqResult.uniqueResult())).getOwnerAccessControlEntry();
            }
        }
        return ownerAce;
    }

    public Boolean updateControlEntry(OwnerAccessControlEntry updatedMasterAce) {
        And cqQuery = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)updatedMasterAce.getUid()), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.DOMAIN, (Object)updatedMasterAce.getDomain()), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.INTERFACENAME, (Object)updatedMasterAce.getInterfaceName()), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.OPERATION, (Object)updatedMasterAce.getOperation()));
        ResultSet cqResult = this.ownerAclDB.retrieve((Query)cqQuery, QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.descending(OwnerAccessControlEntryDB.UID))));
        if (!cqResult.isEmpty()) {
            this.ownerAclDB.remove(cqResult.uniqueResult());
        }
        return this.ownerAclDB.add((Object)new OwnerAccessControlEntryDB(updatedMasterAce));
    }

    public boolean removeControlEntry(String uid, String domain, String interfaceName, String operation) {
        boolean removeResult = false;
        try {
            And cqQuery = QueryFactory.and((Query)QueryFactory.equal(OwnerAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.INTERFACENAME, (Object)interfaceName), (Query)QueryFactory.equal(OwnerAccessControlEntryDB.OPERATION, (Object)operation));
            removeResult = this.ownerAclDB.update((Iterable)this.ownerAclDB.retrieve((Query)cqQuery), new ArrayList());
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            logger.error("Remove masterAcl failed.", (Throwable)e);
        }
        return removeResult;
    }
}

