/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import java.util.Arrays;
import java.util.List;
import joynr.infrastructure.DacTypes.MasterRegistrationControlEntry;
import joynr.infrastructure.DacTypes.OwnerRegistrationControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;

public class RceValidator {
    private MasterRegistrationControlEntry masterRce;
    private MasterRegistrationControlEntry mediatorRce;
    private OwnerRegistrationControlEntry ownerRce;

    public RceValidator(MasterRegistrationControlEntry masterRce, MasterRegistrationControlEntry mediatorRce, OwnerRegistrationControlEntry ownerRce) {
        this.masterRce = masterRce;
        this.mediatorRce = mediatorRce;
        this.ownerRce = ownerRce;
    }

    public boolean isValid() {
        return this.isOwnerValid();
    }

    public boolean isOwnerValid() {
        boolean isOwnerValid = true;
        if (this.mediatorRce != null) {
            isOwnerValid = this.isMediatorValid() && this.validateOwner(this.mediatorRce);
        } else if (this.masterRce != null) {
            isOwnerValid = this.validateOwner(this.masterRce);
        }
        return isOwnerValid;
    }

    private boolean validateOwner(MasterRegistrationControlEntry targetMasterRce) {
        if (this.ownerRce == null) {
            return true;
        }
        boolean isValid = true;
        List<Permission> masterRcePossibleProviderPermissions = Arrays.asList(targetMasterRce.getPossibleProviderPermissions());
        List<TrustLevel> masterRcePossibleRequiredTrustLevels = Arrays.asList(targetMasterRce.getPossibleRequiredTrustLevels());
        if (!masterRcePossibleProviderPermissions.contains(this.ownerRce.getProviderPermission())) {
            isValid = false;
        } else if (!masterRcePossibleRequiredTrustLevels.contains(this.ownerRce.getRequiredTrustLevel())) {
            isValid = false;
        }
        return isValid;
    }

    public boolean isMediatorValid() {
        if (this.mediatorRce == null) {
            return true;
        }
        if (this.masterRce == null) {
            return true;
        }
        boolean isMediatorValid = true;
        List<Permission> masterRcePossibleProviderPermissions = Arrays.asList(this.masterRce.getPossibleProviderPermissions());
        List<Permission> mediatorRcePossibleProviderPermissions = Arrays.asList(this.mediatorRce.getPossibleProviderPermissions());
        List<TrustLevel> masterRcePossibleRequiredTrustLevels = Arrays.asList(this.masterRce.getPossibleRequiredTrustLevels());
        List<TrustLevel> mediatorRcePossibleRequiredTrustLevels = Arrays.asList(this.mediatorRce.getPossibleRequiredTrustLevels());
        if (!masterRcePossibleProviderPermissions.contains(this.mediatorRce.getDefaultProviderPermission())) {
            isMediatorValid = false;
        } else if (!masterRcePossibleProviderPermissions.containsAll(mediatorRcePossibleProviderPermissions)) {
            isMediatorValid = false;
        } else if (!masterRcePossibleRequiredTrustLevels.contains(this.mediatorRce.getDefaultRequiredTrustLevel())) {
            isMediatorValid = false;
        } else if (!masterRcePossibleRequiredTrustLevels.containsAll(mediatorRcePossibleRequiredTrustLevels)) {
            isMediatorValid = false;
        }
        return isMediatorValid;
    }
}

