/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.option.AttributeOrder;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.resultset.ResultSet;
import io.joynr.accesscontrol.DomainAccessControlProvisioning;
import io.joynr.accesscontrol.DomainRoleEntryStore;
import io.joynr.accesscontrol.datatype.MasterAccessControlEntryDB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterAccessControlEntryStore {
    private static final String WILDCARD = "*";
    private static final String WILDCARD_REGEX = "\\*";
    private static final Logger logger = LoggerFactory.getLogger(MasterAccessControlEntryStore.class);
    private DomainRoleEntryStore domainRoleEntryStore;
    private IndexedCollection<MasterAccessControlEntryDB> masterAclDB = new ConcurrentIndexedCollection();

    public MasterAccessControlEntryStore(DomainAccessControlProvisioning domainAccessControlProvisioning, DomainRoleEntryStore domainRoleEntryStore) {
        this.domainRoleEntryStore = domainRoleEntryStore;
        this.masterAclDB.addIndex((Index)HashIndex.onAttribute(MasterAccessControlEntryDB.UID));
        this.masterAclDB.addIndex((Index)HashIndex.onAttribute(MasterAccessControlEntryDB.INTERFACENAME));
        this.masterAclDB.addIndex((Index)HashIndex.onAttribute(MasterAccessControlEntryDB.DOMAIN));
        this.masterAclDB.addIndex((Index)HashIndex.onAttribute(MasterAccessControlEntryDB.OPERATION));
        Collection masterAccessControlEntries = domainAccessControlProvisioning.getMasterAccessControlEntries();
        for (MasterAccessControlEntry provisionedMasterAccessControlEntry : masterAccessControlEntries) {
            this.updateControlEntry(provisionedMasterAccessControlEntry);
        }
    }

    public List<MasterAccessControlEntry> getControlEntries(String uid) {
        ArrayList<MasterAccessControlEntry> controlEntries = new ArrayList<MasterAccessControlEntry>();
        Equal cqQuery = QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)uid);
        this.masterAclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getMasterAccessControlEntry()));
        if (controlEntries.isEmpty()) {
            Equal cqQueryWildcard = QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)WILDCARD);
            this.masterAclDB.retrieve((Query)cqQueryWildcard).forEach(result -> controlEntries.add(result.getMasterAccessControlEntry()));
        }
        return controlEntries;
    }

    public List<MasterAccessControlEntry> getEditableAces(String uid, Role role) {
        ArrayList<MasterAccessControlEntry> controlEntries = new ArrayList<MasterAccessControlEntry>();
        DomainRoleEntry domainRoleEntry = this.domainRoleEntryStore.getDomainRole(uid, role);
        if (domainRoleEntry == null) {
            return controlEntries;
        }
        if (domainRoleEntry.getDomains().length == 0) {
            return controlEntries;
        }
        for (String domain : domainRoleEntry.getDomains()) {
            And cqQuery = QueryFactory.and((Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(MasterAccessControlEntryDB.DOMAIN, (Object)domain));
            this.masterAclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getMasterAccessControlEntry()));
        }
        return controlEntries;
    }

    public List<MasterAccessControlEntry> getControlEntries(String domain, String interfaceName) {
        ArrayList<MasterAccessControlEntry> controlEntries = new ArrayList<MasterAccessControlEntry>();
        And cqQuery = QueryFactory.and((Query)QueryFactory.equal(MasterAccessControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(MasterAccessControlEntryDB.INTERFACENAME, (Object)interfaceName));
        this.masterAclDB.retrieve((Query)cqQuery).forEach(result -> controlEntries.add(result.getMasterAccessControlEntry()));
        return controlEntries;
    }

    public List<MasterAccessControlEntry> getControlEntries(String uid, String domain, String interfaceName) {
        ArrayList<MasterAccessControlEntry> controlEntries = new ArrayList<MasterAccessControlEntry>();
        And cqQuery = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(MasterAccessControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(MasterAccessControlEntryDB.INTERFACENAME, (Object)interfaceName));
        ResultSet cqResult = this.masterAclDB.retrieve((Query)cqQuery, QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.descending(MasterAccessControlEntryDB.UID))));
        String currentUid = null;
        for (MasterAccessControlEntryDB result : cqResult) {
            if (currentUid == null) {
                currentUid = result.getUid();
            } else if (!currentUid.equals(result.getUid())) break;
            controlEntries.add(result.getMasterAccessControlEntry());
        }
        return controlEntries;
    }

    public MasterAccessControlEntry getControlEntry(String uid, String domain, String interfaceName, String operation) {
        MasterAccessControlEntry masterAce = null;
        And cqQuery = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(MasterAccessControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(MasterAccessControlEntryDB.INTERFACENAME, (Object)interfaceName), (Query)QueryFactory.equal(MasterAccessControlEntryDB.OPERATION, (Object)operation));
        ResultSet cqResult = this.masterAclDB.retrieve((Query)cqQuery);
        if (!cqResult.isEmpty()) {
            masterAce = ((MasterAccessControlEntryDB)((Object)cqResult.uniqueResult())).getMasterAccessControlEntry();
        } else {
            And cqQueryWildcard = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(MasterAccessControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(MasterAccessControlEntryDB.INTERFACENAME, (Object)interfaceName), (Query)QueryFactory.equal(MasterAccessControlEntryDB.OPERATION, (Object)WILDCARD));
            cqResult = this.masterAclDB.retrieve((Query)cqQueryWildcard);
            if (!cqResult.isEmpty()) {
                masterAce = ((MasterAccessControlEntryDB)((Object)cqResult.uniqueResult())).getMasterAccessControlEntry();
            } else {
                List matchingEntries;
                And cqQueryWildcardDomain = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(MasterAccessControlEntryDB.WILDCARDDOMAIN, (Object)true), (Query)QueryFactory.equal(MasterAccessControlEntryDB.INTERFACENAME, (Object)interfaceName), (Query)QueryFactory.equal(MasterAccessControlEntryDB.OPERATION, (Object)WILDCARD));
                cqResult = this.masterAclDB.retrieve((Query)cqQueryWildcardDomain);
                if (!cqResult.isEmpty() && !(matchingEntries = cqResult.stream().filter(entry -> entry.getDomain().equals(WILDCARD) || domain.startsWith(entry.getDomain().split(WILDCARD_REGEX)[0])).collect(Collectors.toList())).isEmpty()) {
                    masterAce = ((MasterAccessControlEntryDB)((Object)matchingEntries.get(0))).getMasterAccessControlEntry();
                }
            }
        }
        return masterAce;
    }

    public Boolean updateControlEntry(MasterAccessControlEntry updatedMasterAce) {
        And cqQuery = QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)updatedMasterAce.getUid()), (Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)WILDCARD)), (Query)QueryFactory.equal(MasterAccessControlEntryDB.DOMAIN, (Object)updatedMasterAce.getDomain()), (Query)QueryFactory.equal(MasterAccessControlEntryDB.INTERFACENAME, (Object)updatedMasterAce.getInterfaceName()), (Query)QueryFactory.equal(MasterAccessControlEntryDB.OPERATION, (Object)updatedMasterAce.getOperation()));
        ResultSet cqResult = this.masterAclDB.retrieve((Query)cqQuery, QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.descending(MasterAccessControlEntryDB.UID))));
        if (!cqResult.isEmpty()) {
            this.masterAclDB.remove(cqResult.uniqueResult());
        }
        return this.masterAclDB.add((Object)new MasterAccessControlEntryDB(updatedMasterAce));
    }

    public boolean removeControlEntry(String uid, String domain, String interfaceName, String operation) {
        boolean removeResult = false;
        try {
            And cqQuery = QueryFactory.and((Query)QueryFactory.equal(MasterAccessControlEntryDB.UID, (Object)uid), (Query)QueryFactory.equal(MasterAccessControlEntryDB.DOMAIN, (Object)domain), (Query)QueryFactory.equal(MasterAccessControlEntryDB.INTERFACENAME, (Object)interfaceName), (Query)QueryFactory.equal(MasterAccessControlEntryDB.OPERATION, (Object)operation));
            removeResult = this.masterAclDB.update((Iterable)this.masterAclDB.retrieve((Query)cqQuery), new ArrayList());
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            logger.error("Remove masterAcl failed.", (Throwable)e);
        }
        return removeResult;
    }
}

